/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.service.impl;

import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.rules.rule.event.AddAdHocRoutePersonEvent;
import org.kuali.rice.krad.rules.rule.event.AddAdHocRouteWorkgroupEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.DocumentFormBase;

/**
 * View helper extension for document views.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DocumentViewHelperServiceImpl extends ViewHelperServiceImpl {
    private static final long serialVersionUID = 5311653907592800785L;

    private transient KualiRuleService kualiRuleService;

    /**
     * Performs validation on the new collection line before it is added to the corresponding collection.
     *
     * @param addLine new line instance to validate
     * @param model object instance that contains the views data
     * @return true if the line is valid and it should be added to the
     * collection, false if it was not valid and should not be added to
     * the collection
     */
    @Override
    protected boolean performAddLineValidation(ViewModel model, Object addLine, String collectionId,
            String collectionPath) {
        boolean isValidLine = super.performAddLineValidation(model, addLine, collectionId, collectionPath);

        if (model instanceof DocumentFormBase && addLine instanceof AdHocRoutePerson) {
            DocumentFormBase form = (DocumentFormBase) model;
            isValidLine &= getKualiRuleService().applyRules(new AddAdHocRoutePersonEvent(form.getDocument(),
                    (AdHocRoutePerson) addLine));
        } else if (model instanceof DocumentFormBase && addLine instanceof AdHocRouteWorkgroup) {
            DocumentFormBase form = (DocumentFormBase) model;
            isValidLine &= getKualiRuleService().applyRules(new AddAdHocRouteWorkgroupEvent(form.getDocument(),
                    (AdHocRouteWorkgroup) addLine));
        }

        return isValidLine;
    }

    /**
     * Retrieves an instance of the rule service.
     *
     * @return Kuali rule service
     */
    protected KualiRuleService getKualiRuleService() {
        if (kualiRuleService == null) {
            kualiRuleService = KRADServiceLocatorWeb.getKualiRuleService();
        }

        return this.kualiRuleService;
    }
}
