/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.util;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

import java.io.Serializable;

/**
 * Holds the information for sorting a table by a column.
 *
 * <ul>
 *     <li>column index</li>
 *     <li>direction</li>
 *     <li>sort type</li>
 * </ul>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ColumnSort implements Serializable {

    /**
     * Sort direction, either ASCending or DESCending.
     */
    public enum Direction { ASC, DESC };

    private final int columnIndex;
    private final Direction direction;
    private final String sortType;

    /**
     * Constructs a ColumnSort instance.
     *
     * @param columnIndex the index of the column to sort on
     * @param direction the direction of the sort
     * @param sortType the type of the sort -- see {@link org.kuali.rice.krad.uif.UifConstants.TableToolsValues}.
     */
    public ColumnSort(int columnIndex, Direction direction, String sortType) {
        this.columnIndex = columnIndex;
        this.direction = direction;
        this.sortType = sortType;
    }

    /**
     * Get the column index.
     *
     * @return the column index
     */
    public int getColumnIndex() {
        return columnIndex;
    }

    /**
     * Get the sort direction.
     *
     * @return the sort direction
     */
    public Direction getDirection() {
        return direction;
    }

    /**
     * Get the sort type.
     *
     * @return the sort type
     */
    public String getSortType() {
        return sortType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        return EqualsBuilder.reflectionEquals(this, o);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
}
