/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.util;

import org.kuali.rice.core.api.util.AbstractKeyValue;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

/**
 * Extension of key value for use within the UIF.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "keyValuePair", parent = "Uif-KeyLabelPair")
public class UifKeyValue extends AbstractKeyValue {
    private static final long serialVersionUID = 1176799455504861488L;

    public UifKeyValue() {
        super();
    }

    public UifKeyValue(String key, String value) {
        super(key, value);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    @BeanTagAttribute(name = "key")
    public String getKey() {
        return super.getKey();
    }

    /**
     * {@inheritDoc}
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    @BeanTagAttribute(name = "value")
    public String getValue() {
        return super.getValue();
    }

    /**
     * {@inheritDoc}
     */
    public void setValue(String value) {
        this.value = value;
    }
}
