/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.util;

import org.kuali.rice.krad.uif.component.ListAware;
import org.kuali.rice.krad.uif.element.Header;

import java.io.Serializable;

/**
 * Collection of helper methods that can be exposed to a render engine.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class UifRenderHelperMethods implements Serializable {
    private static final long serialVersionUID = 5105182075655826814L;

    /**
     * Indicates whether the given class is a {@link org.kuali.rice.krad.uif.element.Header}
     * component class.
     *
     * @param componentClass class to check
     * @return boolean true if class is a header class, false if not
     */
    public boolean isHeader(Class<?> componentClass) {
        return Header.class.isAssignableFrom(componentClass);
    }

    /**
     * Indicates whether the given class is a {org.kuali.rice.krad.uif.component.ListAware}
     * component class.
     *
     * @param componentClass class to check
     * @return boolean true if class is a list aware class, false if not
     */
    public boolean isListAware(Class<?> componentClass) {
        return ListAware.class.isAssignableFrom(componentClass);
    }
}
