/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.widget;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

/**
 * Accordion widget class used to create an accordion based layout.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "accordion", parent = "Uif-Accordion")
public class Accordion extends WidgetBase {
    private static final long serialVersionUID = 8156445677141475527L;

    private String active;

    /**
     * The active option determines which accordion item is open by default.  Set "false" as the string for
     * no item open, use zero-based index to select an item to be open by default.
     *
     * @return the accordion item that is open by default, "false" if no items open
     */
    @BeanTagAttribute
    public String getActive() {
        return active;
    }

    /**
     * Set the accordion item open by default (zero-based index), "false" if no item should be open.
     *
     * @param active true if the accoridion item should be open by default
     */
    public void setActive(String active) {
        this.active = active;
    }
}
