/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.widget;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.CssConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.util.LifecycleElement;

/**
 * Decorates a group with scroll functionality.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "scrollpane", parent = "Uif-Scrollpane")
public class Scrollpane  extends WidgetBase {
    private static final long serialVersionUID = 3853028195825084261L;

    private String height;

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);

        if (parent instanceof Component) {
            buildCSSforScrollPane((Component) parent);
        }
    }

    private void buildCSSforScrollPane(Component parent) {
        if (StringUtils.isNotBlank(getHeight())) {
            if (!StringUtils.contains(parent.getStyle(), CssConstants.HEIGHT)) {
                parent.appendToStyle(CssConstants.HEIGHT + getHeight() +";");
            }

            if (!StringUtils.contains(parent.getStyle(), CssConstants.OVERFLOW)) {
                parent.appendToStyle(CssConstants.OVERFLOW + "auto;");
            }
        }
    }

    /**
     * Height the content should take up in the group
     *
     * <p>
     * If the content size exceeds the height then a scroll bar will be shown.
     * </p>
     * <p>
     * e.g. '30%' or '55px'
     * </p>
     *
     * @return Content height of the group
     */
    @BeanTagAttribute
    public String getHeight() {
        return height;
    }

    /**
     * Setter for the group height
     *
     * @param height
     */
    public void setHeight(String height) {
        this.height = height;
    }

}
