/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.widget;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentBase;

/**
 * Base class for Widgets
 *
 * <p>
 * Sets the component type name for all widget components and provides default
 * implementation of performFinalize
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "widget", parent = "Uif-WidgetBase")
public abstract class WidgetBase extends ComponentBase implements Widget {
    private static final long serialVersionUID = -917582902829056830L;

    public WidgetBase() {
        super();
    }

    public WidgetBase(WidgetBase another)   {
        another.setAdditionalComponentsToRefresh(this.getAdditionalComponentsToRefresh());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getComponentTypeName() {
        return "widget";
    }
}
