/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.bind;

import org.kuali.rice.krad.uif.view.ViewModel;
import org.springframework.beans.BeanWrapper;
import org.springframework.util.Assert;
import org.springframework.validation.BeanPropertyBindingResult;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UifBeanPropertyBindingResult extends BeanPropertyBindingResult {
    private static final long serialVersionUID = -3740046436620585003L;

    private final Set<String> modifiedPaths = new HashSet<String>();

    private boolean changeTracking = false;

    public UifBeanPropertyBindingResult(Object target, String objectName, boolean autoGrowNestedPaths,
            int autoGrowCollectionLimit) {
        super(target, objectName, autoGrowNestedPaths, autoGrowCollectionLimit);
    }

    /**
     * Create a new {@link BeanWrapper} for the underlying target object.
     *
     * @see #getTarget()
     */
    @Override
    protected UifViewBeanWrapper createBeanWrapper() {
        Assert.state(super.getTarget() != null,
                "Cannot access properties on null bean instance '" + getObjectName() + "'!");
        Assert.state(super.getTarget() instanceof ViewModel,
                "Object must be instance of ViewModel to use Uif Bean Wrapper");

        return new UifViewBeanWrapper((ViewModel) super.getTarget(), this);
    }

    public Set<String> getModifiedPaths() {
        return Collections.unmodifiableSet(this.modifiedPaths);
    }

    public void addModifiedPath(String path) {
        this.modifiedPaths.add(path);
    }

    public boolean isChangeTracking() {
        return changeTracking;
    }

    public void setChangeTracking(boolean changeTracking) {
        this.changeTracking = changeTracking;
    }

}
