/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.bind;

import org.kuali.rice.core.api.CoreApiServiceLocator;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.security.GeneralSecurityException;

/**
 * Property editor which encrypts values for display and decrypts on binding, uses the
 * {@link org.kuali.rice.core.api.encryption.EncryptionService} to perform the encryption
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class UifEncryptionPropertyEditorWrapper extends PropertyEditorSupport{

    private static org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(UifEncryptionPropertyEditorWrapper.class);

    PropertyEditor propertyEditor;

    /**
     * @param propertyEditor
     */
    public UifEncryptionPropertyEditorWrapper(PropertyEditor propertyEditor) {
        super();
        this.propertyEditor = propertyEditor;
    }

    @Override
    public String getAsText() {
        try {
            if (propertyEditor != null) {
                if(CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                    return CoreApiServiceLocator.getEncryptionService().encrypt(propertyEditor.getAsText());
                }
            }
            if(CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                return CoreApiServiceLocator.getEncryptionService().encrypt(getValue());
            }
            return null;
        } catch (GeneralSecurityException e) {
            LOG.error("Unable to encrypt value");
            throw new RuntimeException("Unable to encrypt value.", e);
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            String value = "";
            if(CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                value = CoreApiServiceLocator.getEncryptionService().decrypt(text);
            }
            if (propertyEditor != null) {
                propertyEditor.setAsText(value);
            } else {
                setValue(value);
            }
        } catch (GeneralSecurityException e) {
            LOG.error("Unable to decrypt value: " + text);
            throw new RuntimeException("Unable to decrypt value.", e);
        }
    }

}
