/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.service;

import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.servlet.ModelAndView;

/**
 * Controller service that provides methods for working with collection groups.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface CollectionControllerService {

    /**
     * Invoked by the add line action to add the add line instance to the model collection.
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView addLine(UifFormBase form);

    /**
     * Invoked by the add blank line action to add a new line instance to the model mollection.
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView addBlankLine(UifFormBase form);

    /**
     * Invoked by the edit line action to show the edit line dialog for the edit line instance to the model collection.
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView retrieveEditLineDialog(UifFormBase form);

    /**
     * Invoked by the edit line action to edit the edit line instance to the model collection.
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView editLine(UifFormBase form);

    /**
     * Invoked by the edit line modal's hidden event to close the edit line dialog.
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView closeEditLineDialog(UifFormBase form);

    /**
     * Invoked by the save line action to save an item within the model collection.
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView saveLine(UifFormBase form);

    /**
     * Invoked by the delete line action to delete an item within the model collection.
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView deleteLine(UifFormBase form);

    /**
     * Invoked by the table paging widget to retrieve a page for a collection group.
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView retrieveCollectionPage(UifFormBase form);

    /**
     * Get method for getting aaData for jquery datatables which are using sAjaxSource option.
     *
     * <p>This will render the aaData JSON for the displayed page of the table matching the tableId passed in the
     * request parameters.</p>
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView tableJsonRetrieval(UifFormBase form);
}
