/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.service;

import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletResponse;

/**
 * Controller service that provides methods for working with the multi-file upload component.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface FileControllerService {

    /**
     * Invoked by the multiFile upload element to add a file object to the collection it controls.
     *
     * @param form form instance containing the file data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView addFileUploadLine(UifFormBase form);

    /**
     * Invoked by the multiFile upload widget to delete a file; Inform the model of file to delete.
     *
     * @param form form instance containing the file data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView deleteFileUploadLine(UifFormBase form);

    /**
     * Invoked by the multiFile upload widget to get the file contents for a file upload line.
     *
     * @param form form instance containing the file request data
     * @param response Http response for streaming back the file contents
     */
    void getFileFromLine(UifFormBase form, HttpServletResponse response);
}
