/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.lookup;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.datadictionary.exception.UnknownBusinessClassAttributeException;
import org.kuali.rice.krad.lookup.LookupForm;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.lifecycle.ComponentPostMetadata;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.PropertyAccessorUtils;

public class LookupUtils {
    private static final Logger LOG = LogManager.getLogger(LookupUtils.class);
    private static final String[] searchList = new String[SearchOperator.QUERY_CHARACTERS.size()];
    private static final String[] replacementList;

    private LookupUtils() {
    }

    public static String retrieveLookupParameterValue(UifFormBase form, HttpServletRequest request, Class<?> lookupObjectClass, String propertyName, String parameterName) {
        if (KRADUtils.isSecure(propertyName, lookupObjectClass)) {
            LOG.warn("field name " + propertyName + " is a secure value and not returned in parameter result value");
            return null;
        }
        String parameterValue = "";
        parameterValue = StringUtils.startsWith((String)parameterName, (String)"'") && StringUtils.endsWith((String)parameterName, (String)"'") ? StringUtils.substringBetween((String)parameterName, (String)"'") : (parameterValue.startsWith("literal=") ? StringUtils.removeStart((String)parameterValue, (String)"literal=") : (request.getParameterMap().containsKey(parameterName) ? request.getParameter(parameterName) : ObjectPropertyUtils.getPropertyValueAsText(form, parameterName)));
        return parameterValue;
    }

    public static String getBaseLookupUrl() {
        return CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("krad.lookup.url");
    }

    public static String forceUppercase(Class<?> dataObjectClass, String fieldName, String fieldValue) {
        if (StringUtils.isBlank((String)fieldValue)) {
            return fieldValue;
        }
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("Parameter dataObjectClass passed in with null value.");
        }
        if (StringUtils.isBlank((String)fieldName)) {
            throw new IllegalArgumentException("Parameter fieldName passed in with empty value.");
        }
        if (!KRADServiceLocatorWeb.getDataDictionaryService().isAttributeDefined(dataObjectClass, fieldName).booleanValue()) {
            return fieldValue;
        }
        boolean forceUpperCase = false;
        try {
            forceUpperCase = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeForceUppercase(dataObjectClass, fieldName);
        }
        catch (UnknownBusinessClassAttributeException unknownBusinessClassAttributeException) {
            // empty catch block
        }
        if (forceUpperCase && !fieldValue.endsWith("(&^#&)")) {
            return fieldValue.toUpperCase();
        }
        return fieldValue;
    }

    public static Map<String, String> forceUppercase(Class<?> dataObjectClass, Map<String, String> fieldValues) {
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("Parameter boClass passed in with null value.");
        }
        if (fieldValues == null) {
            throw new IllegalArgumentException("Parameter fieldValues passed in with null value.");
        }
        for (String fieldName : fieldValues.keySet()) {
            fieldValues.put(fieldName, LookupUtils.forceUppercase(dataObjectClass, fieldName, fieldValues.get(fieldName)));
        }
        return fieldValues;
    }

    public static Integer getSearchResultsLimit(Class dataObjectClass, LookupForm lookupForm) {
        Integer limit = KRADServiceLocatorWeb.getViewDictionaryService().getResultSetLimitForLookup(dataObjectClass, lookupForm);
        if (limit == null) {
            limit = LookupUtils.getApplicationSearchResultsLimit();
        }
        return limit;
    }

    public static Integer getApplicationSearchResultsLimit() {
        String limitString = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-KRAD", "Lookup", "RESULTS_LIMIT");
        if (limitString != null) {
            return Integer.valueOf(limitString);
        }
        return null;
    }

    public static Integer getApplicationMultipleValueSearchResultsLimit() {
        String limitString = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-KRAD", "Lookup", "MULTIPLE_VALUE_RESULTS_LIMIT");
        if (limitString != null) {
            return Integer.valueOf(limitString);
        }
        return null;
    }

    public static Timestamp getActiveDateTimestampForCriteria(Map searchValues) {
        String activeAsOfDate;
        Date activeDate = CoreApiServiceLocator.getDateTimeService().getCurrentSqlDate();
        Timestamp activeTimestamp = null;
        if (searchValues.containsKey("activeAsOfDate") && StringUtils.isNotBlank((String)(activeAsOfDate = (String)searchValues.get("activeAsOfDate")))) {
            try {
                activeDate = CoreApiServiceLocator.getDateTimeService().convertToSqlDate(KRADUtils.clean(activeAsOfDate));
            }
            catch (ParseException e) {
                try {
                    activeTimestamp = CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp(KRADUtils.clean(activeAsOfDate));
                }
                catch (ParseException e1) {
                    throw new RuntimeException("Unable to convert date: " + KRADUtils.clean(activeAsOfDate), e1);
                }
            }
        }
        if (activeTimestamp == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(activeDate);
            cal.set(10, cal.getMaximum(10));
            cal.set(12, cal.getMaximum(12));
            cal.set(13, cal.getMaximum(13));
            activeTimestamp = new Timestamp(cal.getTime().getTime());
        }
        return activeTimestamp;
    }

    public static Map<String, String> preprocessDateFields(Map<String, String> searchCriteria) {
        HashMap<String, Object> fieldsToUpdate = new HashMap<String, Object>();
        HashMap<String, String> searchCriteriaUpdated = new HashMap<String, String>(searchCriteria);
        Set<String> fieldsForLookup = searchCriteria.keySet();
        for (String propName : fieldsForLookup) {
            if (!propName.startsWith("rangeLowerBoundKeyPrefix_")) continue;
            String from_DateValue = searchCriteria.get(propName);
            String dateFieldName = StringUtils.remove((String)propName, (String)"rangeLowerBoundKeyPrefix_");
            String to_DateValue = searchCriteria.get(dateFieldName);
            Object newPropValue = to_DateValue;
            if (StringUtils.isNotEmpty((String)from_DateValue) && StringUtils.isNotEmpty((String)to_DateValue)) {
                newPropValue = from_DateValue + SearchOperator.BETWEEN_EXCLUSIVE_UPPER + to_DateValue;
            } else if (StringUtils.isNotEmpty((String)from_DateValue) && StringUtils.isEmpty((String)to_DateValue)) {
                newPropValue = SearchOperator.GREATER_THAN_EQUAL.op() + from_DateValue;
            } else if (StringUtils.isNotEmpty((String)to_DateValue) && StringUtils.isEmpty((String)from_DateValue)) {
                newPropValue = SearchOperator.LESS_THAN_EQUAL.op() + to_DateValue;
            }
            fieldsToUpdate.put(dateFieldName, newPropValue);
        }
        Set keysToUpdate = fieldsToUpdate.keySet();
        for (String updateKey : keysToUpdate) {
            searchCriteriaUpdated.put(updateKey, (String)fieldsToUpdate.get(updateKey));
        }
        return searchCriteriaUpdated;
    }

    public static boolean hasExternalBusinessObjectProperty(Class<?> boClass, Map<String, String> fieldValues) throws IllegalAccessException, InstantiationException {
        Object sampleBo = boClass.newInstance();
        for (String key : fieldValues.keySet()) {
            if (!LookupUtils.isExternalBusinessObjectProperty(sampleBo, key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExternalBusinessObjectProperty(Object sampleBo, String propertyName) {
        Class<?> propertyClass;
        if (propertyName.indexOf(".") > 0 && !StringUtils.contains((String)propertyName, (String)"add.") && (propertyClass = ObjectPropertyUtils.getPropertyType(sampleBo, StringUtils.substringBeforeLast((String)propertyName, (String)"."))) != null) {
            return ExternalizableBusinessObjectUtils.isExternalizableBusinessObjectInterface(propertyClass);
        }
        return false;
    }

    public static Map<String, String> removeExternalizableBusinessObjectFieldValues(Class<?> boClass, Map<String, String> fieldValues) throws IllegalAccessException, InstantiationException {
        HashMap<String, String> eboFieldValues = new HashMap<String, String>();
        Object sampleBo = boClass.newInstance();
        for (String key : fieldValues.keySet()) {
            if (LookupUtils.isExternalBusinessObjectProperty(sampleBo, key)) continue;
            eboFieldValues.put(key, fieldValues.get(key));
        }
        return eboFieldValues;
    }

    public static Map<String, String> getExternalizableBusinessObjectFieldValues(String eboPropertyName, Map<String, String> fieldValues) {
        HashMap<String, String> eboFieldValues = new HashMap<String, String>();
        for (String key : fieldValues.keySet()) {
            if (!key.startsWith(eboPropertyName + ".")) continue;
            eboFieldValues.put(StringUtils.substringAfterLast((String)key, (String)"."), fieldValues.get(key));
        }
        return eboFieldValues;
    }

    public static List<String> getExternalizableBusinessObjectProperties(Class<?> boClass, Map<String, String> fieldValues) throws IllegalAccessException, InstantiationException {
        HashSet<String> eboPropertyNames = new HashSet<String>();
        Object sampleBo = boClass.newInstance();
        for (String key : fieldValues.keySet()) {
            if (!LookupUtils.isExternalBusinessObjectProperty(sampleBo, key)) continue;
            eboPropertyNames.add(StringUtils.substringBeforeLast((String)key, (String)"."));
        }
        return new ArrayList<String>(eboPropertyNames);
    }

    public static Class<? extends ExternalizableBusinessObject> getExternalizableBusinessObjectClass(Class<?> boClass, String propertyName) throws IllegalAccessException, InstantiationException {
        return ObjectPropertyUtils.getPropertyType(boClass.newInstance(), StringUtils.substringBeforeLast((String)propertyName, (String)"."));
    }

    public static Map<String, String> adjustCriteriaForNestedEBOs(Class<?> dataObjectClass, Map<String, String> searchCriteria, boolean unbounded) throws InstantiationException, IllegalAccessException {
        Map<String, String> nonEboFieldValues = LookupUtils.removeExternalizableBusinessObjectFieldValues(dataObjectClass, searchCriteria);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Non EBO properties removed: " + nonEboFieldValues);
        }
        List<String> eboPropertyNames = LookupUtils.getExternalizableBusinessObjectProperties(dataObjectClass, searchCriteria);
        if (LOG.isDebugEnabled()) {
            LOG.debug("EBO properties: " + eboPropertyNames);
        }
        for (String eboPropertyName : eboPropertyNames) {
            Class eboParentClass;
            String eboParentPropertyName;
            Map<String, Object> eboFieldValues = LookupUtils.getExternalizableBusinessObjectFieldValues(eboPropertyName, searchCriteria);
            if (LOG.isDebugEnabled()) {
                LOG.debug("EBO properties for master EBO property: " + eboPropertyName);
                LOG.debug("properties: " + eboFieldValues);
            }
            ModuleService eboModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(LookupUtils.getExternalizableBusinessObjectClass(dataObjectClass, eboPropertyName));
            List<Object> eboResults = Collections.emptyList();
            if (eboModuleService != null) {
                eboResults = eboModuleService.getExternalizableBusinessObjectsListForLookup(LookupUtils.getExternalizableBusinessObjectClass(dataObjectClass, eboPropertyName), eboFieldValues, unbounded);
            } else {
                LOG.debug("EBO ModuleService is null: " + eboPropertyName);
            }
            if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)eboPropertyName)) {
                eboParentPropertyName = StringUtils.substringBeforeLast((String)eboPropertyName, (String)".");
                try {
                    eboParentClass = KradDataServiceLocator.getDataObjectService().wrap(dataObjectClass.newInstance()).getPropertyType(eboParentPropertyName);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to create an instance of the business object class: " + dataObjectClass.getName(), ex);
                }
            } else {
                eboParentClass = dataObjectClass;
                eboParentPropertyName = null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("determined EBO parent class/property name: " + eboParentClass + "/" + eboParentPropertyName);
            }
            RelationshipDefinition rd = KRADServiceLocatorWeb.getLegacyDataAdapter().getDictionaryRelationship(eboParentClass, eboPropertyName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Obtained RelationshipDefinition for " + eboPropertyName);
                LOG.debug((Object)rd);
            }
            if (!KRADUtils.isNotNull(rd)) continue;
            if (rd.getPrimitiveAttributes().size() > 1) {
                throw new RuntimeException("EBO Links don't work for relationships with multiple-field primary keys.");
            }
            String boProperty = rd.getPrimitiveAttributes().get(0).getSourceName();
            String eboProperty = rd.getPrimitiveAttributes().get(0).getTargetName();
            StringBuffer boPropertyValue = new StringBuffer();
            for (Object ebo : eboResults) {
                if (boPropertyValue.length() != 0) {
                    boPropertyValue.append(SearchOperator.OR.op());
                }
                try {
                    boPropertyValue.append(PropertyUtils.getProperty((Object)ebo, (String)eboProperty).toString());
                }
                catch (Exception ex) {
                    LOG.warn("Unable to get value for " + eboProperty + " on " + ebo, (Throwable)ex);
                }
            }
            if (eboParentPropertyName == null) {
                nonEboFieldValues.put(boProperty, boPropertyValue.toString());
                continue;
            }
            nonEboFieldValues.put(eboParentPropertyName + "." + boProperty, boPropertyValue.toString());
        }
        return nonEboFieldValues;
    }

    public static String scrubQueryCharacters(String criteriaValue) {
        return StringUtils.replaceEach((String)criteriaValue, (String[])searchList, (String[])replacementList);
    }

    public static String generateMultiValueKey(Object lineDataObject, List<String> fieldConversionKeys) {
        Object lineIdentifier = "";
        if (fieldConversionKeys == null || fieldConversionKeys.isEmpty()) {
            lineIdentifier = KRADServiceLocatorWeb.getLegacyDataAdapter().getDataObjectIdentifierString(lineDataObject);
        } else {
            Collections.sort(fieldConversionKeys);
            for (String fromFieldName : fieldConversionKeys) {
                Object fromFieldValue = ObjectPropertyUtils.getPropertyValue(lineDataObject, fromFieldName);
                if (fromFieldValue != null) {
                    lineIdentifier = (String)lineIdentifier + fromFieldValue;
                }
                lineIdentifier = (String)lineIdentifier + ":";
            }
            lineIdentifier = StringUtils.removeEnd((String)lineIdentifier, (String)":");
        }
        return lineIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshLookupResultSelections(LookupForm form) {
        int displayStart = 0;
        int displayLength = 0;
        ViewPostMetadata viewPostMetadata = form.getViewPostMetadata();
        if (viewPostMetadata != null) {
            ViewPostMetadata viewPostMetadata2 = viewPostMetadata;
            synchronized (viewPostMetadata2) {
                ComponentPostMetadata oldCollectionGroup = viewPostMetadata.getComponentPostMetadata("uLookupResults");
                displayStart = (Integer)oldCollectionGroup.getData("displayStart");
                displayLength = (Integer)oldCollectionGroup.getData("displayLength");
            }
        }
        List lookupResults = (List)form.getLookupResults();
        List<String> fromFieldNames = form.getMultiValueReturnFields();
        HashSet<String> selectedLines = form.getSelectedCollectionLines().get("lookupResults");
        Set<String> selectedLookupResultsCache = form.getSelectedLookupResultsCache();
        selectedLines = selectedLines == null ? new HashSet<String>() : selectedLines;
        for (int i = displayStart; i < displayStart + displayLength && i < form.getLookupResults().size(); ++i) {
            Object lineItem = lookupResults.get(i);
            String lineIdentifier = LookupUtils.generateMultiValueKey(lineItem, fromFieldNames);
            if (!selectedLines.contains(lineIdentifier)) {
                selectedLookupResultsCache.remove(lineIdentifier);
                continue;
            }
            selectedLookupResultsCache.add(lineIdentifier);
        }
        selectedLines.addAll(selectedLookupResultsCache);
        form.getSelectedCollectionLines().put("lookupResults", selectedLines);
    }

    static {
        int index = 0;
        for (SearchOperator operator : SearchOperator.QUERY_CHARACTERS) {
            LookupUtils.searchList[index++] = operator.op();
        }
        replacementList = Collections.nCopies(searchList.length, "").toArray(new String[0]);
    }
}

