/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.freemarker.LifecycleRenderingContext;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleProcessorBase;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.util.RecycleUtils;
import org.kuali.rice.krad.uif.view.DefaultExpressionEvaluator;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.ExpressionEvaluatorFactory;
import org.kuali.rice.krad.util.GlobalVariables;

public final class AsynchronousViewLifecycleProcessor
extends ViewLifecycleProcessorBase {
    private static final Logger LOG = LogManager.getLogger(AsynchronousViewLifecycleProcessor.class);
    private static final ThreadFactory LIFECYCLE_THREAD_FACTORY = new LifecycleThreadFactory();
    private static final ThreadPoolExecutor LIFECYCLE_EXECUTOR = new ThreadPoolExecutor(AsynchronousViewLifecycleProcessor.getMinThreads(), AsynchronousViewLifecycleProcessor.getMaxThreads(), AsynchronousViewLifecycleProcessor.getTimeout(), TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), LIFECYCLE_THREAD_FACTORY);
    private static final Deque<AsynchronousLifecyclePhase> PENDING_PHASE_QUEUE = new LinkedList<AsynchronousLifecyclePhase>();
    private static final ThreadLocal<AsynchronousLifecyclePhase> ACTIVE_PHASE = new ThreadLocal();
    private static final Map<LifecycleElement, AsynchronousLifecyclePhase> BUSY_ELEMENTS = new IdentityHashMap<LifecycleElement, AsynchronousLifecyclePhase>();
    private static Integer minThreads;
    private static Integer maxThreads;
    private static Long timeout;
    private final Queue<LifecycleRenderingContext> renderingContextPool = ViewLifecycle.isRenderInLifecycle() ? new ConcurrentLinkedQueue() : null;
    private final Queue<ExpressionEvaluator> expressionEvaluatorPool = new ConcurrentLinkedQueue<ExpressionEvaluator>();
    private Throwable error;

    public static int getMinThreads() {
        if (minThreads == null) {
            String propStr = null;
            if (ConfigContext.getCurrentContextConfig() != null) {
                propStr = ConfigContext.getCurrentContextConfig().getProperty("rice.krad.lifecycle.asynchronous.minThreads");
            }
            minThreads = propStr == null ? 4 : Integer.parseInt(propStr);
        }
        return minThreads;
    }

    public static int getMaxThreads() {
        if (maxThreads == null) {
            String propStr = null;
            if (ConfigContext.getCurrentContextConfig() != null) {
                propStr = ConfigContext.getCurrentContextConfig().getProperty("rice.krad.lifecycle.asynchronous.maxThreads");
            }
            maxThreads = propStr == null ? 48 : Integer.parseInt(propStr);
        }
        return maxThreads;
    }

    public static long getTimeout() {
        if (timeout == null) {
            String propStr = null;
            if (ConfigContext.getCurrentContextConfig() != null) {
                propStr = ConfigContext.getCurrentContextConfig().getProperty("rice.krad.lifecycle.asynchronous.timeout");
            }
            timeout = propStr == null ? 30000L : Long.parseLong(propStr);
        }
        return timeout;
    }

    AsynchronousViewLifecycleProcessor(ViewLifecycle lifecycle) {
        super(lifecycle);
    }

    @Override
    public ViewLifecyclePhase getActivePhase() {
        AsynchronousLifecyclePhase aphase = ACTIVE_PHASE.get();
        if (aphase == null) {
            throw new IllegalStateException("No phase worker is active on this thread");
        }
        ViewLifecyclePhase phase = aphase.phase;
        if (phase == null) {
            throw new IllegalStateException("No lifecycle phase is active on this thread");
        }
        return phase;
    }

    @Override
    void setActivePhase(ViewLifecyclePhase phase) {
        AsynchronousLifecyclePhase aphase = ACTIVE_PHASE.get();
        if (aphase == null) {
            throw new IllegalStateException("No phase worker is active on this thread");
        }
        if (phase == null) {
            return;
        }
        if (aphase.phase != phase) {
            throw new IllegalStateException("Another lifecycle phase is already active on this thread " + aphase.phase + ", setting " + phase);
        }
        aphase.phase = phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LifecycleRenderingContext getRenderingContext() {
        List<String> viewTemplates;
        if (!ViewLifecycle.isRenderInLifecycle()) {
            return null;
        }
        AsynchronousLifecyclePhase aphase = ACTIVE_PHASE.get();
        if (aphase == null) {
            throw new IllegalStateException("No phase worker is active on this thread");
        }
        LifecycleRenderingContext renderContext = aphase.renderingContext;
        if (renderContext != null) {
            return renderContext;
        }
        renderContext = this.renderingContextPool.poll();
        if (renderContext == null) {
            ViewLifecycle lifecycle = this.getLifecycle();
            renderContext = new LifecycleRenderingContext(lifecycle.model, lifecycle.request);
        }
        List<String> list = viewTemplates = ViewLifecycle.getView().getViewTemplates();
        synchronized (list) {
            for (String viewTemplate : viewTemplates) {
                renderContext.importTemplate(viewTemplate);
            }
        }
        aphase.renderingContext = renderContext;
        return renderContext;
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator() {
        ExpressionEvaluator expressionEvaluator;
        AsynchronousLifecyclePhase aphase = ACTIVE_PHASE.get();
        ExpressionEvaluator expressionEvaluator2 = expressionEvaluator = aphase == null ? null : aphase.expressionEvaluator;
        if (expressionEvaluator != null) {
            return expressionEvaluator;
        }
        expressionEvaluator = this.expressionEvaluatorPool.poll();
        if (expressionEvaluator == null) {
            ViewHelperService helper = ViewLifecycle.getHelper();
            ExpressionEvaluatorFactory expressionEvaluatorFactory = helper != null ? helper.getExpressionEvaluatorFactory() : KRADServiceLocatorWeb.getExpressionEvaluatorFactory();
            expressionEvaluator = expressionEvaluatorFactory == null ? new DefaultExpressionEvaluator() : expressionEvaluatorFactory.createExpressionEvaluator();
            if (ViewLifecycle.isActive()) {
                try {
                    expressionEvaluator.initializeEvaluationContext(ViewLifecycle.getModel());
                }
                catch (IllegalStateException e) {
                    LOG.warn("Model is not available", (Throwable)e);
                }
            }
        }
        if (aphase != null) {
            aphase.expressionEvaluator = expressionEvaluator;
        }
        return expressionEvaluator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushPendingPhase(ViewLifecyclePhase phase) {
        Object object;
        AsynchronousLifecyclePhase aphase = this.getAsynchronousPhase(phase);
        if (phase.getStartViewStatus().equals(phase.getElement().getViewStatus())) {
            object = BUSY_ELEMENTS;
            synchronized (object) {
                BUSY_ELEMENTS.put(phase.getElement(), aphase);
            }
        }
        object = PENDING_PHASE_QUEUE;
        synchronized (object) {
            PENDING_PHASE_QUEUE.push(aphase);
            PENDING_PHASE_QUEUE.notify();
        }
        AsynchronousViewLifecycleProcessor.spawnWorkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerPendingPhase(ViewLifecyclePhase phase) {
        Object object;
        AsynchronousLifecyclePhase aphase = this.getAsynchronousPhase(phase);
        if (phase.getStartViewStatus().equals(phase.getElement().getViewStatus())) {
            object = BUSY_ELEMENTS;
            synchronized (object) {
                BUSY_ELEMENTS.put(phase.getElement(), aphase);
            }
        }
        object = PENDING_PHASE_QUEUE;
        synchronized (object) {
            PENDING_PHASE_QUEUE.offer(aphase);
            PENDING_PHASE_QUEUE.notify();
        }
        AsynchronousViewLifecycleProcessor.spawnWorkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performPhase(ViewLifecyclePhase initialPhase) {
        if (this.error != null) {
            throw new RiceRuntimeException("Error performing view lifecycle", this.error);
        }
        long now = System.currentTimeMillis();
        try {
            AsynchronousLifecyclePhase aphase = this.getAsynchronousPhase(initialPhase);
            aphase.initial = true;
            Object object = PENDING_PHASE_QUEUE;
            synchronized (object) {
                PENDING_PHASE_QUEUE.offer(aphase);
                PENDING_PHASE_QUEUE.notify();
            }
            AsynchronousViewLifecycleProcessor.spawnWorkers();
            while (System.currentTimeMillis() - now < AsynchronousViewLifecycleProcessor.getTimeout() && this.error == null && !initialPhase.isComplete()) {
                object = initialPhase;
                synchronized (object) {
                    if (!initialPhase.isComplete()) {
                        LOG.info("Waiting for view lifecycle " + initialPhase);
                        initialPhase.wait(Math.min(5000L, AsynchronousViewLifecycleProcessor.getTimeout()));
                    }
                }
            }
            if (this.error != null) {
                throw new IllegalStateException("Error in lifecycle", this.error);
            }
            if (!initialPhase.isComplete()) {
                this.error = new IllegalStateException("Time out waiting for lifecycle");
                throw (IllegalStateException)this.error;
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted waiting for view lifecycle", e);
        }
    }

    private AsynchronousLifecyclePhase getAsynchronousPhase(ViewLifecyclePhase phase) {
        AsynchronousLifecyclePhase rv = RecycleUtils.getRecycledInstance(AsynchronousLifecyclePhase.class);
        if (rv == null) {
            rv = new AsynchronousLifecyclePhase();
        }
        rv.processor = this;
        rv.globalVariables = GlobalVariables.getCurrentGlobalVariables();
        rv.phase = phase;
        return rv;
    }

    private static void recyclePhase(AsynchronousLifecyclePhase aphase) {
        if (aphase.initial) {
            return;
        }
        assert (aphase.renderingContext == null);
        aphase.processor = null;
        aphase.phase = null;
        aphase.globalVariables = null;
        aphase.expressionEvaluator = null;
        RecycleUtils.recycle(aphase);
    }

    private static void spawnWorkers() {
        int active = LIFECYCLE_EXECUTOR.getActiveCount();
        if (active < LIFECYCLE_EXECUTOR.getCorePoolSize() || active * 16 < PENDING_PHASE_QUEUE.size() && active < LIFECYCLE_EXECUTOR.getMaximumPoolSize()) {
            LIFECYCLE_EXECUTOR.submit(new AsynchronousLifecycleWorker());
        }
    }

    private static class AsynchronousLifecyclePhase {
        private boolean initial;
        private GlobalVariables globalVariables;
        private AsynchronousViewLifecycleProcessor processor;
        private ViewLifecyclePhase phase;
        private ExpressionEvaluator expressionEvaluator;
        private LifecycleRenderingContext renderingContext;

        private AsynchronousLifecyclePhase() {
        }
    }

    private static class AsynchronousLifecycleWorker
    implements Runnable {
        private AsynchronousLifecycleWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PhaseWorkerCall call = new PhaseWorkerCall();
                do {
                    if (PENDING_PHASE_QUEUE.isEmpty()) {
                        Deque<AsynchronousLifecyclePhase> deque = PENDING_PHASE_QUEUE;
                        synchronized (deque) {
                            PENDING_PHASE_QUEUE.wait(15000L);
                        }
                    } else {
                        if (ViewLifecycle.isTrace()) {
                            ProcessLogger.follow("view-lifecycle", "KRAD lifecycle worker", call);
                            continue;
                        }
                        call.call();
                    }
                } while (LIFECYCLE_EXECUTOR.getActiveCount() <= AsynchronousViewLifecycleProcessor.getMinThreads());
            }
            catch (Throwable t) {
                LOG.fatal("Fatal error in View Lifecycle worker", t);
            }
        }
    }

    private static class LifecycleThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup GROUP = new ThreadGroup("krad-lifecycle-group");
        private int sequenceNumber = 0;

        private LifecycleThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(GROUP, r, "krad-lifecycle(" + Integer.toString(++this.sequenceNumber) + ")");
        }
    }

    private static class PhaseWorkerCall
    implements Callable<Void> {
        private PhaseWorkerCall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            while (!PENDING_PHASE_QUEUE.isEmpty()) {
                Map<LifecycleElement, AsynchronousLifecyclePhase> map;
                Object object;
                AsynchronousLifecyclePhase aphase;
                Deque<AsynchronousLifecyclePhase> deque = PENDING_PHASE_QUEUE;
                synchronized (deque) {
                    aphase = PENDING_PHASE_QUEUE.poll();
                }
                if (aphase == null) continue;
                AsynchronousViewLifecycleProcessor processor = aphase.processor;
                ViewLifecyclePhase phase = aphase.phase;
                if (processor.error != null) {
                    ViewLifecyclePhase viewLifecyclePhase = phase;
                    synchronized (viewLifecyclePhase) {
                        phase.notifyAll();
                        continue;
                    }
                }
                LifecycleElement element = phase.getElement();
                AsynchronousLifecyclePhase busyPhase = BUSY_ELEMENTS.get(element);
                if (busyPhase != null && busyPhase != aphase) {
                    object = PENDING_PHASE_QUEUE;
                    synchronized (object) {
                        PENDING_PHASE_QUEUE.offer(aphase);
                        continue;
                    }
                }
                try {
                    assert (ACTIVE_PHASE.get() == null);
                    ACTIVE_PHASE.set(aphase);
                    ViewLifecycle.setProcessor(aphase.processor);
                    GlobalVariables.injectGlobalVariables(aphase.globalVariables);
                    object = element;
                    synchronized (object) {
                        phase.run();
                    }
                }
                catch (Throwable t) {
                    processor.error = t;
                    ViewLifecyclePhase topPhase = phase;
                    while (topPhase.getPredecessor() != null) {
                        topPhase = topPhase.getPredecessor();
                    }
                    map = topPhase;
                    synchronized (map) {
                        topPhase.notifyAll();
                    }
                }
                finally {
                    ACTIVE_PHASE.remove();
                    LifecycleRenderingContext renderingContext = aphase.renderingContext;
                    aphase.renderingContext = null;
                    if (renderingContext != null && aphase.processor != null) {
                        aphase.processor.renderingContextPool.offer(renderingContext);
                    }
                    ExpressionEvaluator expressionEvaluator = aphase.expressionEvaluator;
                    aphase.expressionEvaluator = null;
                    if (expressionEvaluator != null && aphase.processor != null) {
                        aphase.processor.expressionEvaluatorPool.offer(expressionEvaluator);
                    }
                    map = BUSY_ELEMENTS;
                    synchronized (map) {
                        BUSY_ELEMENTS.remove(element);
                    }
                    GlobalVariables.popGlobalVariables();
                    ViewLifecycle.setProcessor(null);
                }
                AsynchronousViewLifecycleProcessor.recyclePhase(aphase);
            }
            return null;
        }
    }
}

