/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.persistence.Convert;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.component.ClientSideState;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Image;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.ActionField;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.ImageField;
import org.kuali.rice.krad.uif.field.LinkField;
import org.kuali.rice.krad.uif.field.MessageField;
import org.kuali.rice.krad.uif.field.SpaceField;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADConstants;
import org.kuali.rice.krad.util.LegacyUtils;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.NumberUtils;

public final class KRADUtils {
    private static final Logger LOG = LogManager.getLogger(KRADUtils.class);
    private static KualiModuleService kualiModuleService;

    private KRADUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static Object hydrateAttributeValue(Class<?> propertyType, String attributeValue) {
        Object attributeValueObject = null;
        if (propertyType != null && attributeValue != null) {
            attributeValueObject = String.class.equals(propertyType) ? attributeValue : (Boolean.class.equals(propertyType) || Boolean.TYPE.equals(propertyType) ? Truth.strToBooleanIgnoreCase((String)attributeValue) : KRADUtils.createObject(propertyType, new Class[]{String.class}, new Object[]{attributeValue}));
        }
        return attributeValueObject;
    }

    public static Object createObject(Class<?> clazz, Class<?>[] argumentClasses, Object[] argumentValues) {
        if (clazz == null) {
            return null;
        }
        if (argumentClasses.length == 1 && argumentClasses[0] == String.class && argumentValues.length == 1 && argumentValues[0] != null) {
            if (clazz == String.class) {
                return argumentValues[0];
            }
            Method valueOfMethod = null;
            try {
                valueOfMethod = clazz.getMethod("valueOf", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (valueOfMethod != null) {
                try {
                    return valueOfMethod.invoke(null, argumentValues[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(argumentClasses);
            return constructor.newInstance(argumentValues);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String joinWithQuotes(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        return "'" + StringUtils.join(list.iterator(), (String)"','") + "'";
    }

    public static String getNamespaceCode(Class<?> clazz) {
        ModuleService moduleService = KRADUtils.getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService == null) {
            return "KUALI";
        }
        return moduleService.getModuleConfiguration().getNamespaceCode();
    }

    public static Map<String, String> getNamespaceAndComponentSimpleName(Class<?> clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespaceCode", KRADUtils.getNamespaceCode(clazz));
        map.put("componentName", KRADUtils.getComponentSimpleName(clazz));
        return map;
    }

    public static Map<String, String> getNamespaceAndComponentFullName(Class<?> clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespaceCode", KRADUtils.getNamespaceCode(clazz));
        map.put("componentName", KRADUtils.getComponentFullName(clazz));
        return map;
    }

    public static Map<String, String> getNamespaceAndActionClass(Class<?> clazz) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespaceCode", KRADUtils.getNamespaceCode(clazz));
        map.put("actionClass", clazz.getName());
        return map;
    }

    private static String getComponentSimpleName(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    private static String getComponentFullName(Class<?> clazz) {
        return clazz.getName();
    }

    public static Map<String, String> convertStringParameterToMap(String parameter) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)parameter)) {
            if (StringUtils.contains((String)parameter, (String)",")) {
                String[] fieldConversions;
                for (String fieldConversionStr : fieldConversions = StringUtils.split((String)parameter, (String)",")) {
                    if (!StringUtils.isNotBlank((String)fieldConversionStr)) continue;
                    if (StringUtils.contains((String)fieldConversionStr, (String)":")) {
                        String[] fieldConversion = fieldConversionStr.split(":", -1);
                        map.put(fieldConversion[0], fieldConversion[1]);
                        continue;
                    }
                    map.put(fieldConversionStr, fieldConversionStr);
                }
            } else if (StringUtils.contains((String)parameter, (String)":")) {
                String[] fieldConversion = parameter.split(":", -1);
                map.put(fieldConversion[0], fieldConversion[1]);
            } else {
                map.put(parameter, parameter);
            }
        }
        return map;
    }

    public static List<String> convertStringParameterToList(String parameter) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)parameter)) {
            if (StringUtils.contains((String)parameter, (String)",")) {
                String[] parameters = StringUtils.split((String)parameter, (String)",");
                List<String> arraysList = Arrays.asList(parameters);
                list.addAll(arraysList);
            } else {
                list.add(parameter);
            }
        }
        return list;
    }

    public static String translateToMapSafeKey(String key) {
        String safeKey = key;
        safeKey = StringUtils.replace((String)safeKey, (String)"[", (String)"_");
        safeKey = StringUtils.replace((String)safeKey, (String)"]", (String)"_");
        return safeKey;
    }

    public static String buildMapParameterString(Map<String, String> map) {
        Object parameterString = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtils.isNotBlank((String)parameterString)) {
                parameterString = (String)parameterString + ",";
            }
            parameterString = (String)parameterString + entry.getKey() + ":" + entry.getValue();
        }
        return parameterString;
    }

    public static Map<String, String> getMapFromParameterString(String parameterString) {
        String[] entries;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : entries = parameterString.split(",")) {
            Object[] keyValue = entry.split(":");
            if (keyValue.length != 2) {
                throw new RuntimeException("malformed field conversion pair: " + Arrays.toString(keyValue));
            }
            map.put((String)keyValue[0], (String)keyValue[1]);
        }
        return map;
    }

    public static Map<String, String> translateRequestParameterMap(Map<String, String[]> requestParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry<String, String[]> parameter : requestParameters.entrySet()) {
            String parameterValue = parameter.getValue().length > 1 ? StringUtils.join((Object[])parameter.getValue(), (String)"|") : parameter.getValue()[0];
            parameters.put(parameter.getKey(), parameterValue);
        }
        return parameters;
    }

    public static Map<String, String> getParametersFromRequest(List<String> parameterNames, Class<?> parentObjectClass, Map<String, String> requestParameters) {
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (String keyPropertyName : parameterNames) {
            if (requestParameters.get(keyPropertyName) == null) continue;
            String keyValue = requestParameters.get(keyPropertyName);
            boolean isSecure = KRADUtils.isSecure(keyPropertyName, parentObjectClass);
            if (StringUtils.endsWith((String)keyValue, (String)"(&^#&)")) {
                keyValue = StringUtils.removeEnd((String)keyValue, (String)"(&^#&)");
                isSecure = true;
            }
            if (isSecure) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        keyValue = CoreApiServiceLocator.getEncryptionService().decrypt(keyValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    String message = "Data object class " + parentObjectClass + " property " + keyPropertyName + " should have been encrypted, but there was a problem decrypting it.";
                    LOG.error(message);
                    throw new RuntimeException(message, e);
                }
            }
            parameterValues.put(keyPropertyName, keyValue);
        }
        return parameterValues;
    }

    public static Map<String, String> getPropertyKeyValuesFromDataObject(List<String> propertyNames, Object dataObject) {
        return KRADUtils.getPropertyKeyValuesFromDataObject(propertyNames, Collections.emptyList(), dataObject);
    }

    public static Map<String, String> getPropertyKeyValuesFromDataObject(List<String> propertyNames, List<String> securePropertyNames, Object dataObject) {
        HashMap<String, String> propertyKeyValues = new HashMap<String, String>();
        if (dataObject == null) {
            return propertyKeyValues;
        }
        for (String propertyName : propertyNames) {
            String propertyValue = ObjectPropertyUtils.getPropertyValueAsText(dataObject, propertyName);
            if (propertyValue == null) {
                propertyValue = "";
            }
            if (KRADUtils.isSecure(propertyName, securePropertyNames, dataObject.getClass())) continue;
            propertyKeyValues.put(propertyName, propertyValue);
        }
        return propertyKeyValues;
    }

    public static boolean isSecure(String propertyName, Class<?> dataObjectClass) {
        return KRADUtils.isSecure(propertyName, Collections.emptyList(), dataObjectClass);
    }

    public static boolean isSecure(String propertyName, List<String> securePropertyNames, Class<?> dataObjectClass) {
        if (KRADUtils.containsSecurePropertyName(propertyName, securePropertyNames)) {
            return true;
        }
        return KRADServiceLocatorWeb.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(dataObjectClass, propertyName);
    }

    private static boolean containsSecurePropertyName(String propertyName, List<String> securePropertyNames) {
        if (securePropertyNames == null) {
            return false;
        }
        for (String securePropertyName : securePropertyNames) {
            if (!Pattern.compile("(?:\\.|^)" + Pattern.quote(securePropertyName) + "(?:\\.|\\[|$)").matcher(propertyName).find()) continue;
            return true;
        }
        return false;
    }

    public static Properties convertMapToProperties(Map<String, String> parameters) {
        Properties properties = new Properties();
        if (parameters != null) {
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                properties.put(parameter.getKey(), parameter.getValue());
            }
        }
        return properties;
    }

    public static Properties convertRequestMapToProperties(Map<String, String[]> requestParameters) {
        Properties properties = new Properties();
        if (requestParameters != null) {
            for (Map.Entry<String, String[]> parameter : requestParameters.entrySet()) {
                Object[] parameterValue = parameter.getValue();
                String parameterValueString = StringUtils.join((Object[])parameterValue, (String)",");
                properties.put(parameter.getKey(), parameterValueString);
            }
        }
        return properties;
    }

    public static Map<String, Object> coerceRequestParameterTypes(Class<?> dataObjectClass, Map<String, String> parameters) {
        HashMap<String, Object> filteredFieldValues = new HashMap<String, Object>();
        List<Field> allFields = ObjectPropertyUtils.getAllFields(new ArrayList<Field>(), dataObjectClass, Object.class);
        for (String fieldName : parameters.keySet()) {
            Class<?> propertyType = ObjectPropertyUtils.getPropertyType(dataObjectClass, fieldName);
            String strValue = parameters.get(fieldName);
            if (TypeUtils.isBooleanClass(propertyType) && KRADUtils.isConvertAnnotationPresent(allFields, fieldName)) {
                filteredFieldValues.put(fieldName, Truth.strToBooleanIgnoreCase((String)strValue));
            } else {
                if (TypeUtils.isIntegralClass(propertyType) || TypeUtils.isDecimalClass(propertyType)) {
                    try {
                        filteredFieldValues.put(fieldName, KRADUtils.hydrateAttributeValue(propertyType, strValue));
                    }
                    catch (Exception nfe) {
                        GlobalVariables.getMessageMap().putError("parameters[" + fieldName + "]", "error.invalidNumber", new String[]{strValue});
                        throw new RuntimeException("Could not parse property value into Number for " + fieldName, nfe);
                    }
                }
                if (TypeUtils.isTemporalClass(propertyType)) {
                    try {
                        filteredFieldValues.put(fieldName, CoreApiServiceLocator.getDateTimeService().convertToSqlDate(strValue));
                    }
                    catch (ParseException pe) {
                        GlobalVariables.getMessageMap().putError("parameters[" + fieldName + "]", "error.invalidDateTime", new String[]{strValue});
                        throw new RuntimeException("Could not parse property value into java.sql.Date for " + fieldName, pe);
                    }
                }
            }
            if (filteredFieldValues.get(fieldName) != null) continue;
            filteredFieldValues.put(fieldName, parameters.get(fieldName));
        }
        return filteredFieldValues;
    }

    private static boolean isConvertAnnotationPresent(List<Field> allFields, String fieldName) {
        boolean convertAnnotationFound = false;
        for (Field f : allFields) {
            if (!f.getName().equalsIgnoreCase(fieldName)) continue;
            if (f.getAnnotation(Convert.class) == null) break;
            convertAnnotationFound = true;
            break;
        }
        return convertAnnotationFound;
    }

    public static boolean containsSensitiveDataPatternMatch(String fieldValue) {
        if (StringUtils.isBlank((String)fieldValue)) {
            return false;
        }
        ParameterService parameterService = CoreFrameworkServiceLocator.getParameterService();
        Collection sensitiveDataPatterns = parameterService.getParameterValuesAsString("KR-NS", "All", "SENSITIVE_DATA_PATTERNS");
        for (String pattern : sensitiveDataPatterns) {
            if (!Pattern.compile(pattern).matcher(fieldValue).find()) continue;
            return true;
        }
        return false;
    }

    public static String[] stripXSSPatterns(String[] values) {
        ArrayList<String> strippedValues = new ArrayList<String>();
        for (String value : values) {
            strippedValues.add(KRADUtils.stripXSSPatterns(value));
        }
        return strippedValues.toArray(new String[0]);
    }

    public static String stripXSSPatterns(String value) {
        if (value == null) {
            return null;
        }
        value = value.replaceAll("", "");
        Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("</script>", 2);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("<script(.*?)>", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("expression\\((.*?)\\)", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("javascript:", 2);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("vbscript:", 2);
        value = scriptPattern.matcher(value).replaceAll("");
        scriptPattern = Pattern.compile("onload(.*?)=", 42);
        value = scriptPattern.matcher(value).replaceAll("");
        return value;
    }

    public static UserSession getUserSessionFromRequest(HttpServletRequest request) {
        return (UserSession)request.getSession().getAttribute("UserSession");
    }

    public static boolean isProductionEnvironment() {
        return CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("production.environment.code").equalsIgnoreCase(CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("environment"));
    }

    public static String getMessageText(ErrorMessage errorMessage, boolean processPrefixSuffix) {
        Object message = "";
        if (errorMessage != null && errorMessage.getErrorKey() != null) {
            MessageService messageService = KRADServiceLocatorWeb.getMessageService();
            message = messageService.getMessageText(errorMessage.getNamespaceCode(), errorMessage.getComponentCode(), errorMessage.getErrorKey());
            if (message == null) {
                message = "Intended message with key: " + errorMessage.getErrorKey() + " not found.";
            }
            if (errorMessage.getMessageParameters() != null && StringUtils.isNotBlank((String)message)) {
                message = ((String)message).replace("'", "''");
                message = MessageFormat.format((String)message, errorMessage.getMessageParameters());
            }
            if (StringUtils.isNotBlank((String)errorMessage.getMessagePrefixKey()) && processPrefixSuffix) {
                String prefix = messageService.getMessageText(errorMessage.getNamespaceCode(), errorMessage.getComponentCode(), errorMessage.getMessagePrefixKey());
                if (errorMessage.getMessagePrefixParameters() != null && StringUtils.isNotBlank((String)prefix)) {
                    prefix = prefix.replace("'", "''");
                    prefix = MessageFormat.format(prefix, errorMessage.getMessagePrefixParameters());
                }
                if (StringUtils.isNotBlank((String)prefix)) {
                    message = prefix + " " + (String)message;
                }
            }
            if (StringUtils.isNotBlank((String)errorMessage.getMessageSuffixKey()) && processPrefixSuffix) {
                String suffix = messageService.getMessageText(errorMessage.getNamespaceCode(), errorMessage.getComponentCode(), errorMessage.getMessageSuffixKey());
                if (errorMessage.getMessageSuffixParameters() != null && StringUtils.isNotBlank((String)suffix)) {
                    suffix = suffix.replace("'", "''");
                    suffix = MessageFormat.format(suffix, errorMessage.getMessageSuffixParameters());
                }
                if (StringUtils.isNotBlank((String)suffix)) {
                    message = (String)message + " " + suffix;
                }
            }
        }
        return message;
    }

    public static void logErrors() {
        if (!GlobalVariables.getMessageMap().hasErrors()) {
            return;
        }
        for (Map.Entry e : GlobalVariables.getMessageMap().getAllPropertiesAndErrors()) {
            StringBuilder logMessage = KRADUtils.buildMessage(e);
            LOG.error((CharSequence)logMessage);
        }
    }

    private static StringBuilder buildMessage(Map.Entry<String, List<ErrorMessage>> e) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("[").append(e.getKey()).append("] ");
        boolean first = true;
        List<ErrorMessage> errorList = e.getValue();
        for (ErrorMessage em : errorList) {
            if (first) {
                first = false;
            } else {
                logMessage.append(";");
            }
            logMessage.append(em);
        }
        return logMessage;
    }

    public static String getRequestStringFromMap(Map<String, String> requestParameters) {
        Object requestString = "";
        if (requestParameters.isEmpty()) {
            return requestString;
        }
        URLCodec urlCodec = new URLCodec(KRADConstants.DEFAULT_ENCODING.name());
        for (String key : requestParameters.keySet()) {
            String value = null;
            try {
                value = urlCodec.encode(requestParameters.get(key));
            }
            catch (EncoderException e) {
                throw new RuntimeException("Unable to encode parameter name or value: " + key + "=" + value, e);
            }
            if (StringUtils.isNotBlank((String)requestString)) {
                requestString = (String)requestString + "&";
            }
            requestString = (String)requestString + key + "=" + value;
        }
        return "?" + (String)requestString;
    }

    public static void addAttachmentToResponse(HttpServletResponse response, InputStream inputStream, String contentType, String fileName, long fileSize) throws IOException {
        String updateFileName = fileName.contains("\"") ? fileName.replaceAll("\"", "") : fileName;
        response.setContentType(contentType);
        response.setContentLength(((Integer)NumberUtils.convertNumberToTargetClass((Number)fileSize, Integer.class)).intValue());
        response.setHeader("Content-disposition", "attachment; filename=\"" + updateFileName + "\"");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        if (inputStream != null) {
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
    }

    public static String buildViewUrl(String baseUrl, String controllerMapping, String viewId) {
        Assert.hasLength((String)baseUrl, (String)"base url is null or empty");
        Assert.hasLength((String)controllerMapping, (String)"controller mapping is null or empty");
        Assert.hasLength((String)viewId, (String)"view id is null or empty");
        StringBuilder url = new StringBuilder();
        url.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            url.append("/");
        }
        url.append(controllerMapping);
        url.append("?");
        url.append("viewId");
        url.append("=");
        url.append(viewId);
        return url.toString();
    }

    public static String getFullURL(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }

    public static boolean areDifferentDomains(String firstDomain, String secondDomain) {
        try {
            URL urlOne = new URL(firstDomain.toLowerCase());
            URL urlTwo = new URL(secondDomain.toLowerCase());
            if (urlOne.getHost().equals(urlTwo.getHost())) {
                LOG.debug("Hosts " + urlOne.getHost() + " of domains " + firstDomain + " and " + secondDomain + " were determined to be equal");
                return false;
            }
            LOG.debug("Hosts " + urlOne.getHost() + " of domains " + firstDomain + " and " + secondDomain + " are not equal");
            return true;
        }
        catch (MalformedURLException mue) {
            LOG.error("Unable to successfully compare domains " + firstDomain + " and " + secondDomain, (Throwable)mue);
            return true;
        }
    }

    public static String generateUniqueViewTitle(UifFormBase form, View view) {
        String title = view.getHeader().getHeaderText();
        String viewLabelPropertyName = "";
        Class<?> dataObjectClass = StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath()) ? ObjectPropertyUtils.getPropertyType(form, view.getDefaultBindingObjectPath()) : view.getFormClass();
        if (dataObjectClass != null) {
            viewLabelPropertyName = KRADServiceLocatorWeb.getLegacyDataAdapter().getTitleAttribute(dataObjectClass);
        }
        Object viewLabelPropertyPath = "";
        if (StringUtils.isNotBlank((String)viewLabelPropertyName)) {
            if (!viewLabelPropertyName.startsWith("#form.")) {
                if (StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath())) {
                    viewLabelPropertyPath = view.getDefaultBindingObjectPath() + "." + viewLabelPropertyName;
                }
            } else {
                viewLabelPropertyPath = StringUtils.removeStart((String)viewLabelPropertyName, (String)"#form.");
            }
        } else {
            String titleAttribute;
            dataObjectClass = StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath()) ? ViewModelUtils.getObjectClassForMetadata(view, form, view.getDefaultBindingObjectPath()) : view.getFormClass();
            if (dataObjectClass != null && StringUtils.isNotBlank((String)(titleAttribute = KRADServiceLocatorWeb.getLegacyDataAdapter().getTitleAttribute(dataObjectClass)))) {
                viewLabelPropertyPath = view.getDefaultBindingObjectPath() + "." + titleAttribute;
            }
        }
        Object viewLabelPropertyValue = null;
        if (StringUtils.isNotBlank((String)viewLabelPropertyPath) && ObjectPropertyUtils.isReadableProperty(form, (String)viewLabelPropertyPath)) {
            viewLabelPropertyValue = ObjectPropertyUtils.getPropertyValueAsText(form, (String)viewLabelPropertyPath);
        }
        if (viewLabelPropertyValue != null && StringUtils.isNotBlank((String)viewLabelPropertyValue.toString()) && StringUtils.isNotBlank((String)title)) {
            return title + " (" + viewLabelPropertyValue.toString() + ")";
        }
        return title;
    }

    public static String buildAttributeTitleString(String prependText, Class<?> element, Map<String, String> keyValueMap) {
        StringBuilder titleText = new StringBuilder(prependText);
        for (String key : keyValueMap.keySet()) {
            String fieldVal = keyValueMap.get(key);
            titleText.append(" ").append(KRADServiceLocatorWeb.getDataDictionaryService().getAttributeLabel(element, key)).append("=").append(fieldVal);
        }
        return titleText.toString();
    }

    public static String getSimpleFieldValue(Object model, org.kuali.rice.krad.uif.field.Field field) {
        if (field == null) {
            return null;
        }
        String value = null;
        if (field instanceof DataField) {
            String propertyPath = ((DataField)field).getBindingInfo().getBindingPath();
            String valueObject = null;
            if (field.isHidden()) {
                return "";
            }
            if (ObjectPropertyUtils.isReadableProperty(model, propertyPath)) {
                valueObject = ObjectPropertyUtils.getPropertyValueAsText(model, propertyPath);
            }
            if (valueObject != null && !((DataField)field).isApplyMask()) {
                value = valueObject.toString();
            } else if (valueObject != null && ((DataField)field).isApplyMask()) {
                value = ((DataField)field).getMaskFormatter().maskValue(valueObject);
            }
        } else if (field instanceof ActionField) {
            value = ((ActionField)field).getActionLabel();
            if (StringUtils.isBlank((String)value) && ((ActionField)field).getActionImage() != null) {
                value = ((ActionField)field).getActionImage().getAltText();
            }
        } else if (field instanceof LinkField) {
            value = ((LinkField)field).getLinkText();
        } else if (field instanceof ImageField) {
            value = ((ImageField)field).getAltText();
        } else if (field instanceof MessageField && ((MessageField)field).getMessage() != null) {
            value = ((MessageField)field).getMessage().getMessageText();
        } else if (field instanceof SpaceField) {
            value = "";
        } else if (field instanceof FieldGroup && ((FieldGroup)field).getGroup() != null && ((FieldGroup)field).getGroup().getItems() != null && !((FieldGroup)field).getGroup().getItems().isEmpty()) {
            Component firstComponent = ((FieldGroup)field).getGroup().getItems().get(0);
            value = firstComponent instanceof org.kuali.rice.krad.uif.field.Field ? KRADUtils.getSimpleFieldValue(model, (org.kuali.rice.krad.uif.field.Field)firstComponent) : (firstComponent instanceof Action && StringUtils.isNotBlank((String)((Action)firstComponent).getActionLabel()) ? ((Action)firstComponent).getActionLabel() : (firstComponent instanceof Action && ((Action)firstComponent).getActionImage() != null ? ((Action)firstComponent).getActionImage().getAltText() : (firstComponent instanceof Link ? ((Link)firstComponent).getLinkText() : (firstComponent instanceof Image ? ((Image)firstComponent).getAltText() : (firstComponent instanceof Message ? ((Message)firstComponent).getMessageText() : null)))));
        }
        return value;
    }

    public static String convertToHTMLAttributeSafeString(String message) {
        if (StringUtils.isBlank((String)message)) {
            return message;
        }
        if (message.contains("\"")) {
            message = message.replace("\"", "&quot;");
        }
        if (message.contains("'")) {
            message = message.replace("'", "&#39;");
        }
        if (message.contains("\\")) {
            message = message.replace("\\", "&#92;");
        }
        return message;
    }

    public static String generateRowCssClassString(Map<String, String> conditionalRowCssClasses, int lineIndex, boolean isOdd, Map<String, Object> lineContext, ExpressionEvaluator expressionEvaluator) {
        StringBuilder rowCss = new StringBuilder();
        if (conditionalRowCssClasses == null || conditionalRowCssClasses.isEmpty()) {
            return rowCss.toString();
        }
        for (String cssRule : conditionalRowCssClasses.keySet()) {
            if (cssRule.startsWith("@{") && lineContext != null && expressionEvaluator != null) {
                String outcome = expressionEvaluator.evaluateExpressionTemplate(lineContext, cssRule);
                if (!Boolean.parseBoolean(outcome)) continue;
                rowCss.append(" ").append(conditionalRowCssClasses.get(cssRule));
                continue;
            }
            if (cssRule.equals("all")) {
                rowCss.append(" ").append(conditionalRowCssClasses.get(cssRule));
                continue;
            }
            if (cssRule.equals("even") && !isOdd) {
                rowCss.append(" ").append(conditionalRowCssClasses.get(cssRule));
                continue;
            }
            if (cssRule.equals("odd") && isOdd) {
                rowCss.append(" ").append(conditionalRowCssClasses.get(cssRule));
                continue;
            }
            if (!StringUtils.isNumeric((String)cssRule) || lineIndex + 1 != Integer.parseInt(cssRule)) continue;
            rowCss.append(" ").append(conditionalRowCssClasses.get(cssRule));
        }
        rowCss = new StringBuilder(StringUtils.removeStart((String)rowCss.toString(), (String)" "));
        return rowCss.toString();
    }

    public static Class<?> easyGetPropertyType(Object object, String propertyName) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (LegacyUtils.useLegacyForObject(object)) {
            return PropertyUtils.getPropertyType((Object)object, (String)propertyName);
        }
        return KradDataServiceLocator.getDataObjectService().wrap(object).getPropertyType(propertyName);
    }

    public static void setObjectProperty(Object bo, String propertyName, Object propertyValue) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> propertyType = KRADUtils.easyGetPropertyType(bo, propertyName);
        KRADUtils.setObjectProperty(bo, propertyName, propertyType, propertyValue);
    }

    public static <T> void setObjectProperty(Object bo, String propertyName, Class<T> propertyType, T propertyValue) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        KRADServiceLocatorWeb.getLegacyDataAdapter().setObjectProperty(bo, propertyName, propertyType, propertyValue);
    }

    public static String clean(String string) {
        for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
            string = StringUtils.replace((String)string, (String)op.op(), (String)"");
        }
        return string;
    }

    public static boolean isNull(Object object) {
        if (object == null) {
            return true;
        }
        return KRADServiceLocatorWeb.getLegacyDataAdapter().isNull(object);
    }

    public static boolean isNotNull(Object object) {
        return !KRADUtils.isNull(object);
    }

    public static Class<?> materializeClassForProxiedObject(Object object) {
        return KRADServiceLocatorWeb.getLegacyDataAdapter().materializeClassForProxiedObject(object);
    }

    public static void materializeObjects(Collection<?> possiblyProxiedObjects) {
        for (Object possiblyProxiedObject : possiblyProxiedObjects) {
            KRADUtils.isNotNull(possiblyProxiedObject);
        }
    }

    public static String getNestedAttributePrefix(String attributeName) {
        int lastIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)attributeName);
        return lastIndex != -1 ? StringUtils.substring((String)attributeName, (int)0, (int)lastIndex) : "";
    }

    public static String getNestedAttributePrimitive(String attributeName) {
        int lastIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)attributeName);
        return lastIndex != -1 ? StringUtils.substring((String)attributeName, (int)(lastIndex + 1)) : attributeName;
    }

    public static Object getNestedValue(Object bo, String fieldName) {
        return KRADServiceLocatorWeb.getLegacyDataAdapter().getNestedValue(bo, fieldName);
    }

    public static <T> T createNewObjectFromClass(Class<T> clazz) {
        if (clazz == null) {
            throw new RuntimeException("BO class was passed in as null");
        }
        return (T)KRADServiceLocatorWeb.getLegacyDataAdapter().createNewObjectFromClass(clazz);
    }

    private static KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    public static void syncClientSideStateForComponent(Component component, Map<String, Object> clientSideState) {
        Map componentState = null;
        if (component instanceof View) {
            componentState = clientSideState;
        } else if (clientSideState.containsKey(component.getId())) {
            componentState = (Map)clientSideState.get(component.getId());
        }
        if (componentState != null && !componentState.isEmpty()) {
            Map<String, Annotation> annotatedFields = CopyUtils.getFieldsWithAnnotation(component.getClass(), ClientSideState.class);
            for (Map.Entry<String, Annotation> annotatedField : annotatedFields.entrySet()) {
                ClientSideState clientSideStateAnnot = (ClientSideState)annotatedField.getValue();
                String variableName = clientSideStateAnnot.variableName();
                if (StringUtils.isBlank((String)variableName)) {
                    variableName = annotatedField.getKey();
                }
                if (!componentState.containsKey(variableName)) continue;
                Object value = componentState.get(variableName);
                ObjectPropertyUtils.setPropertyValue(component, annotatedField.getKey(), value);
            }
        }
    }
}

