/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.rules.rule;

import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.document.Document;

/**
 * Defines a rule which gets invoked immediately before a document has a adHocRoutePerson added to it.
 */
public interface AddAdHocRoutePersonRule extends BusinessRule {
    /**
     * This method is responsible for housing business rules that need to be checked before a document adHocRoutePerson is added to
     * a document.
     *
     * @param document
     * @param adHocRoutePerson
     * @return false if the rule fails
     */
    public boolean processAddAdHocRoutePerson(Document document, AdHocRoutePerson adHocRoutePerson);
}
