/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.component;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;

import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.uif.util.LifecycleAwareList;

/**
 * Annotation for {@link Copyable} fields to indicate that a delayed copy proxy should be used
 * instead of the original component when performing a deep copying on the field.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface DelayedCopy {

    /**
     * May be used to indicate the presence of this annotation on the field referring to the object
     * should be used to determine if this field should be delayed.
     * 
     * <p>
     * For example, {@link LifecycleAwareList} is a delegating list wrapper and since it implements
     * the {@link List} interface is treated as a {@link List} rather than a {@link Copyable} when
     * performing a deep copy. The presence of {@DelayedCopy} with {@link #inherit()}
     * set to true on the delegate indicates that the items in the delegated list should be delayed
     * only if the undelegated list reference also has the {@link DelayedCopy} annotation.
     * </p>
     * 
     * @return True if the parent field determines whether or not to delay copying the field, false
     *         to always delay copy of the annotated field.
     */
    boolean inherit() default false;

}
