/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents a group of HTML Radio controls. Provides preset options for the
 * user to choose by a series of radio controls. Only one option can be selected
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTags({@BeanTag(name = "verticalRadioControl", parent = "Uif-VerticalRadioControl"),
        @BeanTag(name = "horizontalRadioControl", parent = "Uif-HorizontalRadioControl")})
public class RadioGroupControl extends MultiValueControlBase {
    private static final long serialVersionUID = 8800478332086081970L;
    private List<String> fieldsetClasses;

    private String delimiter;

    public RadioGroupControl() {
        super();
        fieldsetClasses = new ArrayList<String>();
    }

    /**
     * Delimiter string to be rendered between the radio group options, defaults
     * to none
     *
     * @return delimiter string
     */
    @BeanTagAttribute
    public String getDelimiter() {
        return this.delimiter;
    }

    /**
     * Setter for the string delimiter for each radio option
     *
     * @param delimiter delimeter to render between options
     */
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    /**
     * Get fieldsetClasses which are the classes that will be applied to this component's fieldset when generated
     *
     * @return css classes for the fieldset
     */
    @BeanTagAttribute
    public List<String> getFieldsetClasses() {
        return fieldsetClasses;
    }

    /**
     * Set fieldsetClasses
     *
     * @param fieldsetClasses css classes for the fieldset
     */
    public void setFieldsetClasses(List<String> fieldsetClasses) {
        this.fieldsetClasses = fieldsetClasses;
    }

    /**
     * Builds the HTML class attribute string by combining the fieldsetClasses list
     * with a space delimiter
     *
     * @return class attribute string
     */
    public String getFieldsetClassesAsString() {
        if (fieldsetClasses != null) {
            return StringUtils.join(fieldsetClasses, " ");
        }

        return "";
    }
}
