/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle;

import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.view.View;

/**
 * Performs the pre-process phase on a view, for use prior to caching.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ViewLifecyclePreProcessBuild implements Runnable {

    /**
     * {@inheritDoc}
     */
    @Override
    public void run() {
        View view = ViewLifecycle.getView();

        ViewLifecyclePhase phase = KRADServiceLocatorWeb.getViewLifecyclePhaseBuilder().buildPhase(view,
                UifConstants.ViewPhases.PRE_PROCESS, null);

        ProcessLogger.trace("pre-view-lifecycle:" + view.getId());

        ViewLifecycle.getProcessor().performPhase(phase);
    }

}
