/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.provider.PersistenceProvider;
import org.kuali.rice.krad.data.provider.Provider;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.service.BusinessObjectNotLookupableException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.LookupService;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.rice.krad.util.UrlFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public abstract class RemoteModuleServiceBase
implements ModuleService {
    protected static final Logger LOG = LogManager.getLogger(RemoteModuleServiceBase.class);
    protected ModuleConfiguration moduleConfiguration;
    protected KualiModuleService kualiModuleService;
    protected ApplicationContext applicationContext;
    protected ConfigurationService kualiConfigurationService;
    protected LookupService lookupService;
    protected LegacyDataAdapter legacyDataAdapter;

    @Override
    public boolean isResponsibleFor(Class businessObjectClass) {
        Class externalizableBusinessObjectInterface;
        ModuleConfiguration mc = this.getModuleConfiguration();
        if (mc == null) {
            throw new IllegalStateException("Module configuration has not been initialized for the module service.");
        }
        if (businessObjectClass == null) {
            return false;
        }
        if (this.packagePrefixesMatchesDataObject(businessObjectClass)) {
            return true;
        }
        if (this.persistenceProvidersMatchDataObject(businessObjectClass)) {
            return true;
        }
        if (ExternalizableBusinessObject.class.isAssignableFrom(businessObjectClass) && (externalizableBusinessObjectInterface = ExternalizableBusinessObjectUtils.determineExternalizableBusinessObjectSubInterface((Class)businessObjectClass)) != null) {
            return this.packagePrefixesMatchesDataObject(externalizableBusinessObjectInterface);
        }
        return false;
    }

    protected boolean packagePrefixesMatchesDataObject(Class dataObjectClass) {
        String pckg = dataObjectClass.getPackage().getName();
        if (this.getModuleConfiguration().getExcludedPackagePrefixes() != null) {
            for (String prefix : this.getModuleConfiguration().getExcludedPackagePrefixes()) {
                if (!pckg.startsWith(prefix)) continue;
                return false;
            }
        }
        if (this.getModuleConfiguration().getPackagePrefixes() != null) {
            for (String prefix : this.getModuleConfiguration().getPackagePrefixes()) {
                if (!pckg.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean persistenceProvidersMatchDataObject(Class dataObjectClass) {
        List<Provider> providers = this.getModuleConfiguration().getProviders();
        if (providers != null) {
            for (Provider provider : providers) {
                if (!(provider instanceof PersistenceProvider) || !((PersistenceProvider)provider).handles(dataObjectClass)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isNonBlankValueForKey(Map<String, Object> map, String key) {
        if (map == null) {
            return false;
        }
        Object result = map.get(key);
        if (result instanceof String) {
            return !StringUtils.isBlank((String)((String)result));
        }
        return result != null;
    }

    @Override
    public List listPrimaryKeyFieldNames(Class businessObjectInterfaceClass) {
        Class clazz = this.getExternalizableBusinessObjectImplementation(businessObjectInterfaceClass);
        return KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(clazz);
    }

    @Override
    public BusinessObjectEntry getExternalizableBusinessObjectDictionaryEntry(Class businessObjectInterfaceClass) {
        Class boClass = this.getExternalizableBusinessObjectImplementation(businessObjectInterfaceClass);
        return boClass == null ? null : KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntryForConcreteClass(boClass.getName());
    }

    @Override
    public String getExternalizableDataObjectInquiryUrl(Class<?> inquiryDataObjectClass, Properties parameters) {
        String baseUrl = this.getBaseInquiryUrl();
        if (ExternalizableBusinessObject.class.isAssignableFrom(inquiryDataObjectClass)) {
            Class<ExternalizableBusinessObject> implementationClass = this.getExternalizableBusinessObjectImplementation(inquiryDataObjectClass.asSubclass(ExternalizableBusinessObject.class));
            if (implementationClass == null) {
                throw new RuntimeException("Can't find ExternalizableBusinessObject implementation class for " + inquiryDataObjectClass.getName());
            }
            parameters.put("dataObjectClassName", implementationClass.getName());
        }
        return UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters);
    }

    protected String getBaseInquiryUrl() {
        return this.getKualiConfigurationService().getPropertyValueAsString("krad.inquiry.url");
    }

    @Override
    public String getExternalizableDataObjectLookupUrl(Class<?> lookupDataObjectClass, Properties parameters) {
        String baseUrl = this.getBaseLookupUrl();
        if (ExternalizableBusinessObject.class.isAssignableFrom(lookupDataObjectClass)) {
            Class<ExternalizableBusinessObject> implementationClass = this.getExternalizableBusinessObjectImplementation(lookupDataObjectClass.asSubclass(ExternalizableBusinessObject.class));
            if (implementationClass == null) {
                throw new RuntimeException("Can't find ExternalizableBusinessObject implementation class for " + lookupDataObjectClass.getName());
            }
            parameters.put("dataObjectClassName", implementationClass.getName());
        }
        return UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters);
    }

    protected String getRiceBaseLookupUrl() {
        return BaseLookupUrlsHolder.remoteKradBaseLookupUrl;
    }

    protected String getBaseLookupUrl() {
        return this.getRiceBaseLookupUrl();
    }

    @Override
    @Deprecated
    public String getExternalizableBusinessObjectInquiryUrl(Class inquiryBusinessObjectClass, Map<String, String[]> parameters) {
        if (!this.isExternalizable(inquiryBusinessObjectClass)) {
            return "";
        }
        Class implementationClass = this.getExternalizableBusinessObjectImplementation(inquiryBusinessObjectClass);
        if (implementationClass == null) {
            LOG.error("Can't find ExternalizableBusinessObject implementation class for " + inquiryBusinessObjectClass.getName());
            throw new RuntimeException("Can't find ExternalizableBusinessObject implementation class for interface " + inquiryBusinessObjectClass.getName());
        }
        String businessObjectClassAttribute = implementationClass.getName();
        return UrlFactory.parameterizeUrl((String)this.getInquiryUrl(inquiryBusinessObjectClass), (Properties)this.getUrlParameters(businessObjectClassAttribute, parameters));
    }

    @Override
    @Deprecated
    public String getExternalizableBusinessObjectLookupUrl(Class inquiryBusinessObjectClass, Map<String, String> parameters) {
        Properties urlParameters = new Properties();
        String riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kr.url");
        Object lookupUrl = riceBaseUrl;
        if (!((String)lookupUrl).endsWith("/")) {
            lookupUrl = (String)lookupUrl + "/";
        }
        lookupUrl = parameters.containsKey("multipleValues") ? (String)lookupUrl + "multipleValueLookup.do" : (String)lookupUrl + "lookup.do";
        for (String paramName : parameters.keySet()) {
            urlParameters.put(paramName, parameters.get(paramName));
        }
        Class clazz = this.getExternalizableBusinessObjectImplementation(inquiryBusinessObjectClass);
        urlParameters.put("businessObjectClassName", clazz == null ? "" : clazz.getName());
        return UrlFactory.parameterizeUrl((String)lookupUrl, (Properties)urlParameters);
    }

    @Override
    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsListForLookup(Class<T> externalizableBusinessObjectClass, Map<String, Object> fieldValues, boolean unbounded) {
        Class<T> implementationClass = this.getExternalizableBusinessObjectImplementation(externalizableBusinessObjectClass);
        if (this.isExternalizableBusinessObjectLookupable(implementationClass)) {
            HashMap<String, String> searchCriteria = new HashMap<String, String>();
            for (Map.Entry<String, Object> fieldValue : fieldValues.entrySet()) {
                if (fieldValue.getValue() != null) {
                    searchCriteria.put(fieldValue.getKey(), fieldValue.getValue().toString());
                    continue;
                }
                searchCriteria.put(fieldValue.getKey(), null);
            }
            return (List)this.getLookupService().findCollectionBySearchHelper(implementationClass, searchCriteria, unbounded);
        }
        throw new BusinessObjectNotLookupableException("External business object is not a Lookupable:  " + String.valueOf(implementationClass));
    }

    @Override
    public <T extends ExternalizableBusinessObject> T retrieveExternalizableBusinessObjectIfNecessary(BusinessObject businessObject, T currentInstanceExternalizableBO, String externalizableRelationshipName) {
        Class clazz;
        if (businessObject == null) {
            return null;
        }
        try {
            Class propertyType = PropertyUtils.getPropertyType((Object)businessObject, (String)externalizableRelationshipName);
            clazz = this.getExternalizableBusinessObjectImplementation(propertyType);
        }
        catch (Exception iex) {
            LOG.warn("Exception:" + String.valueOf(iex) + " thrown while trying to get property type for property:" + externalizableRelationshipName + " from business object:" + String.valueOf(businessObject));
            return null;
        }
        BusinessObjectEntry entry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntries().get(businessObject.getClass().getSimpleName());
        RelationshipDefinition relationshipDefinition = entry.getRelationshipDefinition(externalizableRelationshipName);
        List<PrimitiveAttributeDefinition> primitiveAttributeDefinitions = relationshipDefinition.getPrimitiveAttributes();
        HashMap<String, Object> fieldValuesInEBO = new HashMap<String, Object>();
        Object targetPropertyValue = null;
        boolean sourceTargetPropertyValuesSame = true;
        for (PrimitiveAttributeDefinition primitiveAttributeDefinition : primitiveAttributeDefinitions) {
            Object sourcePropertyValue = KradDataServiceLocator.getDataObjectService().wrap((Object)businessObject).getPropertyValueNullSafe(primitiveAttributeDefinition.getSourceName());
            if (currentInstanceExternalizableBO != null) {
                targetPropertyValue = KradDataServiceLocator.getDataObjectService().wrap(currentInstanceExternalizableBO).getPropertyValueNullSafe(primitiveAttributeDefinition.getTargetName());
            }
            if (sourcePropertyValue == null) {
                return null;
            }
            if (targetPropertyValue == null || targetPropertyValue != null && !targetPropertyValue.equals(sourcePropertyValue)) {
                sourceTargetPropertyValuesSame = false;
            }
            fieldValuesInEBO.put(primitiveAttributeDefinition.getTargetName(), sourcePropertyValue);
        }
        if (!sourceTargetPropertyValuesSame) {
            return (T)this.getExternalizableBusinessObject(clazz, fieldValuesInEBO);
        }
        return currentInstanceExternalizableBO;
    }

    public List<? extends ExternalizableBusinessObject> retrieveExternalizableBusinessObjectsList(BusinessObject businessObject, String externalizableRelationshipName, Class externalizableClazz) {
        if (businessObject == null) {
            return null;
        }
        String className = businessObject.getClass().getName();
        String key = className.substring(className.lastIndexOf(".") + 1);
        BusinessObjectEntry entry = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntries().get(key);
        RelationshipDefinition relationshipDefinition = entry.getRelationshipDefinition(externalizableRelationshipName);
        List<PrimitiveAttributeDefinition> primitiveAttributeDefinitions = relationshipDefinition.getPrimitiveAttributes();
        HashMap<String, Object> fieldValuesInEBO = new HashMap<String, Object>();
        for (PrimitiveAttributeDefinition primitiveAttributeDefinition : primitiveAttributeDefinitions) {
            Object sourcePropertyValue = KradDataServiceLocator.getDataObjectService().wrap((Object)businessObject).getPropertyValueNullSafe(primitiveAttributeDefinition.getSourceName());
            if (sourcePropertyValue == null) {
                return null;
            }
            fieldValuesInEBO.put(primitiveAttributeDefinition.getTargetName(), sourcePropertyValue);
        }
        return this.getExternalizableBusinessObjectsList(this.getExternalizableBusinessObjectImplementation(externalizableClazz), fieldValuesInEBO);
    }

    @Override
    public <E extends ExternalizableBusinessObject> Class<E> getExternalizableBusinessObjectImplementation(Class<E> externalizableBusinessObjectInterface) {
        if (this.getModuleConfiguration() == null) {
            throw new IllegalStateException("Module configuration has not been initialized for the module service.");
        }
        Map<Class, Class> ebos = this.getModuleConfiguration().getExternalizableBusinessObjectImplementations();
        if (ebos == null) {
            return null;
        }
        if (ebos.containsValue(externalizableBusinessObjectInterface)) {
            return externalizableBusinessObjectInterface;
        }
        Class implementationClass = ebos.get(externalizableBusinessObjectInterface);
        int implClassModifiers = implementationClass.getModifiers();
        if (Modifier.isInterface(implClassModifiers) || Modifier.isAbstract(implClassModifiers)) {
            throw new RuntimeException("Implementation class must be non-abstract class: ebo interface: " + externalizableBusinessObjectInterface.getName() + " impl class: " + implementationClass.getName() + " module: " + this.getModuleConfiguration().getNamespaceCode());
        }
        return implementationClass;
    }

    @Deprecated
    protected Properties getUrlParameters(String businessObjectClassAttribute, Map<String, String[]> parameters) {
        Properties urlParameters = new Properties();
        for (String paramName : parameters.keySet()) {
            String[] parameterValues = parameters.get(paramName);
            if (parameterValues.length <= 0) continue;
            urlParameters.put(paramName, parameterValues[0]);
        }
        urlParameters.put("businessObjectClassName", businessObjectClassAttribute);
        urlParameters.put("methodToCall", "continueWithInquiry");
        return urlParameters;
    }

    @Deprecated
    protected String getInquiryUrl(Class inquiryBusinessObjectClass) {
        String riceBaseUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kr.url");
        Object inquiryUrl = riceBaseUrl;
        if (!((String)inquiryUrl).endsWith("/")) {
            inquiryUrl = (String)inquiryUrl + "/";
        }
        return (String)inquiryUrl + "inquiry.do";
    }

    public void afterPropertiesSet() {
        KualiModuleService kualiModuleService;
        try {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
            if (kualiModuleService == null) {
                kualiModuleService = (KualiModuleService)this.applicationContext.getBean("kualiModuleService");
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            kualiModuleService = (KualiModuleService)this.applicationContext.getBean("kualiModuleService");
        }
        kualiModuleService.getInstalledModuleServices().add(this);
    }

    @Override
    public ModuleConfiguration getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public void setModuleConfiguration(ModuleConfiguration moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }

    @Override
    public boolean isExternalizable(Class boClazz) {
        if (boClazz == null) {
            return false;
        }
        return ExternalizableBusinessObject.class.isAssignableFrom(boClazz);
    }

    @Override
    public <T extends ExternalizableBusinessObject> T createNewObjectFromExternalizableClass(Class<T> boClass) {
        try {
            return (T)((ExternalizableBusinessObject)this.getExternalizableBusinessObjectImplementation(boClass).newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create externalizable business object class", e);
        }
    }

    public DataObjectRelationship getBusinessObjectRelationship(Class boClass, String attributeName, String attributePrefix) {
        return null;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    protected ConfigurationService getKualiConfigurationService() {
        if (this.kualiConfigurationService == null) {
            this.kualiConfigurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.kualiConfigurationService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public List<List<String>> listAlternatePrimaryKeyFieldNames(Class businessObjectInterfaceClass) {
        return null;
    }

    @Override
    public boolean isLocked() {
        ModuleConfiguration configuration = this.getModuleConfiguration();
        if (configuration != null) {
            String namespaceCode = configuration.getNamespaceCode();
            String componentCode = "All";
            String parameterName = "OLTP_LOCKOUT_ACTIVE_IND";
            ParameterService parameterService = CoreFrameworkServiceLocator.getParameterService();
            String shouldLockout = parameterService.getParameterValueAsString(namespaceCode, componentCode, parameterName);
            if (StringUtils.isNotBlank((String)shouldLockout)) {
                return parameterService.getParameterValueAsBoolean(namespaceCode, componentCode, parameterName);
            }
        }
        return false;
    }

    protected LookupService getLookupService() {
        return this.lookupService != null ? this.lookupService : KRADServiceLocatorWeb.getLookupService();
    }

    protected LegacyDataAdapter getLegacyDataAdapter() {
        return this.legacyDataAdapter != null ? this.legacyDataAdapter : KRADServiceLocatorWeb.getLegacyDataAdapter();
    }

    @Override
    public boolean goToCentralRiceForInquiry() {
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("applicationContext", (Object)this.applicationContext.getDisplayName()).append("moduleConfiguration", (Object)this.moduleConfiguration).toString();
    }

    protected static final class BaseLookupUrlsHolder {
        public static final String localKradBaseLookupUrl;
        public static final String remoteKradBaseLookupUrl;

        protected BaseLookupUrlsHolder() {
        }

        static {
            remoteKradBaseLookupUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("rice.server.krad.lookup.url");
            localKradBaseLookupUrl = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("krad.lookup.url");
        }
    }
}

