/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.view.ViewModel;

import java.util.List;

/**
 * Values finder that can taken the {@link org.kuali.rice.krad.uif.view.ViewModel} that provides data to the view
 * for conditionally setting the valid options
 *
 * <p>
 * Values finder also allows configuration for a blank option that will be added by the framework
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface UifKeyValuesFinder extends KeyValuesFinder {

    /**
     * Builds a list of key values representations for valid value selections using the given view model
     * to retrieve values from other fields and conditionally building the options
     *
     * @param model object instance containing the view data
     *
     * @return List of KeyValue objects
     */
    public List<KeyValue> getKeyValues(ViewModel model);

    /**
     * Builds a list of key values representations for valid value selections using the given view model
     * to retrieve values from other fields and conditionally building the options
     *
     * @param model  object instance containing the view data
     * @param field  object instance containing the field data of the key value lookup
     *
     * @return List of KeyValue objects
     */
    public List<KeyValue> getKeyValues(ViewModel model, InputField field);

    /**
     * Indicates whether a blank option should be included as a valid option
     *
     * @return boolean true if the blank option should be given, false if not
     */
    public boolean isAddBlankOption();
}
