/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

/**
 * This new feedback service was added to refactor
 * KualiExceptionIncidentService.  Now the KualiExceptionIncidentService
 * extends this service so that exception reporting is considered to be a type
 * of feedback.  Both services share the emailReport method which formats and
 * sends an email to the appropriate list.
 */
public interface KualiFeedbackService {

	/**
     * This property must be defined in the base configuration file for specifying
     * the mailing list for the report to be sent.
     * <p>Example:
     * <code>
     * &lt;param name="KualiFeedbackService.REPORT_MAIL_LIST"&gt;a@y,b@z&lt;/param&gt;
     * </code>
     */
    public static final String REPORT_MAIL_LIST = String.format("%s.REPORT_MAIL_LIST", KualiFeedbackService.class.getSimpleName());

	/**
     * This method send email to the defined mailing list with a specified subject and
     * message.
     */
    public void emailReport(String subject, String message) throws Exception;

    public void sendFeedback(String documentId, String componentName, String description) throws Exception;
}
