/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle;

/**
 * Represents a discrete task within the view lifecycle. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @param <T> top level lifecycle element type this task applies to
 */
public interface ViewLifecycleTask<T> extends Runnable {
    
    /**
     * Gets the top level lifecycle element type that this task applies to.
     * 
     * <p>
     * If an element is not a subclass of this type, then the task will not be performed on that
     * element.
     * </p>
     * 
     * @return lifecycle element type
     */
    Class<T> getElementType();

    /**
     * Gets the phase this lifecycle task is a part of.
     * 
     * @return lifecycle phase
     */
    LifecycleElementState getElementState();

    /**
     * @see #getElementState()
     */
    void setElementState(LifecycleElementState lifecycleElementState);
    
}
