/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.bind;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates that the form annotated with this annotation has change tracking enabled.
 *
 * <p>Use this on a subclass of {@link org.kuali.rice.krad.web.form.UifFormBase} to enable this change tracking.
 * Subclasses of a form with change tracking enabled can specify this annotation and {@code enabled = false} to disable
 * changing tracking.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface ChangeTracking {

    /**
     * True if change tracking should be enabled for the annotated form, false if not.
     *
     * @return true if change tracking enabled, false otherwise
     */
    boolean enabled() default true;

}

