/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Image;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.FieldBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="imageField", parent="Uif-ImageField")
public class ImageField
extends FieldBase {
    private static final long serialVersionUID = -7994212503770623408L;
    private Image image;

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (this.getFieldLabel() != null && this.getImage() != null && StringUtils.isNotBlank((String)this.getImage().getId())) {
            this.getFieldLabel().setLabelForComponentId(this.getImage().getId());
        }
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @BeanTagAttribute
    public String getSource() {
        return this.image.getSource();
    }

    public void setSource(String source) {
        this.image.setSource(source);
    }

    @BeanTagAttribute
    public String getAltText() {
        return this.image.getAltText();
    }

    public void setAltText(String altText) {
        this.image.setAltText(altText);
    }

    @BeanTagAttribute
    public String getHeight() {
        return this.image.getHeight();
    }

    public void setHeight(String height) {
        this.image.setHeight(height);
    }

    @Override
    @BeanTagAttribute
    public String getWidth() {
        return this.image.getWidth();
    }

    @Override
    public void setWidth(String width) {
        if (this.image != null) {
            this.image.setWidth(width);
        }
    }

    @BeanTagAttribute
    public String getCaptionHeaderText() {
        return this.image.getCaptionHeaderText();
    }

    public void setCaptionHeaderText(String captionHeaderText) {
        this.image.setCaptionHeaderText(captionHeaderText);
    }

    @BeanTagAttribute
    public Header getCaptionHeader() {
        return this.image.getCaptionHeader();
    }

    public void setCaptionHeader(Header captionHeader) {
        this.image.setCaptionHeader(captionHeader);
    }

    @BeanTagAttribute
    public String getCutlineText() {
        return this.image.getCutlineText();
    }

    public void setCutlineText(String cutlineText) {
        this.image.setCutlineText(cutlineText);
    }

    @BeanTagAttribute
    public Message getCutline() {
        return this.image.getCutlineMessage();
    }

    public void setCutline(Message cutline) {
        this.image.setCutlineMessage(cutline);
    }

    @BeanTagAttribute
    public boolean isCaptionHeaderAboveImage() {
        return this.image.isCaptionHeaderPlacementAboveImage();
    }

    public void setCaptionHeaderAboveImage(boolean captionHeaderAboveImage) {
        this.image.setCaptionHeaderPlacementAboveImage(captionHeaderAboveImage);
    }
}

