/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.exception;

import org.kuali.rice.krad.datadictionary.DataDictionaryException;

/**
 * Exception thrown when a class can't be found during class-related validation.
 */
public class ClassValidationException extends DataDictionaryException {

    private static final long serialVersionUID = 3404751680645748547L;

    /**
     * @param message
     */
    public ClassValidationException(String message) {
        super(message);
    }

    /**
     * @param message
     */
    public ClassValidationException(String message, Throwable t) {
        super(message, t);
    }
}
