/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.uif;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

/**
 * Spring <code>BeanPostProcessor</code> that processes configured <code>Component</code>
 * instances in the dictionary.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ComponentBeanPostProcessor implements BeanPostProcessor {

    public ComponentBeanPostProcessor() {
    }

    /**
     * @see org.springframework.beans.factory.config.BeanPostProcessor#postProcessBeforeInitialization(java.lang.Object,
     *      java.lang.String)
     */
    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    /**
     * Sets the unique Id for a <code>Component</code> if bean name given (not generated) and the id property was
     * not set for the view.
     *
     * <p>
     * The ID will only be set here if an id is given for the Spring bean. For inner beans, the ID will be generated
     * during the view lifecycle
     * </p>
     *
     * @see org.springframework.beans.factory.config.BeanPostProcessor#postProcessAfterInitialization(java.lang.Object,
     *      java.lang.String)
     */
    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Component) {
            Component component = (Component) bean;

            if (StringUtils.isBlank(component.getId())) {
                if (!StringUtils.contains(beanName, "$") && !StringUtils.contains(beanName, "#")) {
                    component.setId(beanName);
                }
            }
        }

        return bean;
    }
}
