/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint.resolver;

import org.kuali.rice.krad.datadictionary.validation.capability.CaseConstrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;

import java.util.Collections;
import java.util.List;

/**
 * CaseConstraintResolver returns the case constraint as a list for a definition implementing the capability {@link
 * CaseConstrainable}
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @param <T> constrainable type
 */
public class CaseConstraintResolver<T extends CaseConstrainable> implements ConstraintResolver<T> {

    @Override
    public <C extends Constraint> List<C> resolve(T definition) {
        @SuppressWarnings("unchecked") C caseConstraint = (C) definition.getCaseConstraint();
        return (caseConstraint == null) ? null : Collections.<C>singletonList(caseConstraint);
    }

}
