/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.maintenance;

import java.util.List;

/**
 * Provides contract for implementing a bulk update withing the bulk update framework.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface BulkUpdateMaintainable extends Maintainable {

    /**
     * Check if the maintenance object is in a state that allows it to be persisted.
     *
     * @return true if maintenance object is persistable, false otherwise
     */
    boolean isPersistable();

    /**
     * Returns the list of updated data objects.
     *
     * @return list of updated data objects
     */
    List<Object> generateUpdatableObjects();

}
