/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.rules.rule.event;

import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.CompleteDocumentRule;

import java.util.ArrayList;
import java.util.List;

/**
 * Complete document event
 *
 * @author Kuali Rice Team (kuali-rice@googlegroups.com)
 */
public class CompleteDocumentEvent extends DocumentEventBase {

    /**
     * Constructs a RouteDocumentEvent with the specified errorPathPrefix and document
     *
     * @param errorPathPrefix
     * @param document
     */
    public CompleteDocumentEvent(String errorPathPrefix, Document document) {
        super("creating complete event for document " + getDocumentId(document), errorPathPrefix, document);
    }

    /**
     * Constructs a RouteDocumentEvent with the given document
     *
     * @param document
     */
    public CompleteDocumentEvent(Document document) {
        this("", document);
    }

    /**
     * @see RuleEvent#getRuleInterfaceClass()
     */
    @Override
    public Class getRuleInterfaceClass() {
        return CompleteDocumentRule.class;
    }

    /**
     * @see RuleEvent#invokeRuleMethod(org.kuali.rice.krad.rules.rule.BusinessRule)
     */
    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((CompleteDocumentRule) rule).processCompleteDocument(document);
    }

    /**
     * @see RuleEvent#generateEvents()
     */
    @Override
    public List<RuleEvent> generateEvents() {
        List events = new ArrayList();
        events.add(new RouteDocumentEvent(getDocument()));
        return events;
    }
}
