/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.event.AddAdHocRoutePersonEvent;
import org.kuali.rice.krad.rules.rule.event.AddAdHocRouteWorkgroupEvent;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;

import java.util.List;

/**
 * Defines the interface to the business-rule evaluation service, used to evauluate document-type-specific business
 * rules using document-related events to drive the process.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface KualiRuleService {

    /**
     * Retrieves and instantiates the businessRulesClass associated with the event's document type (if any), and calls
     * the appropriate process* method of that businessRule for handling the given event type.
     *
     * <p>This is a helper method that takes in the generic DocumentEvent class and determines which event call to
     * make.</p>
     *
     * @param event
     * @return true if no rule is applied, or all rules are applied successfully, false otherwise
     */
    boolean applyRules(DocumentEvent event);

    /**
     * Builds a list containing ad hoc route person events appropriate for the context.
     *
     * @param document
     * @return List
     */
    List<AddAdHocRoutePersonEvent> generateAdHocRoutePersonEvents(Document document);

    /**
     * Builds a list containing ad hoc route workgroup events appropriate for the context.
     *
     * @param document
     * @return List
     */
    List<AddAdHocRouteWorkgroupEvent> generateAdHocRouteWorkgroupEvents(Document document);

    /**
     * Allows code in actions or business objects to directly access rule methods in the class.
     *
     * @param document
     * @param ruleInterface
     * @return BusinessRule
     */
    BusinessRule getBusinessRulesInstance(Document document, Class<? extends BusinessRule> ruleInterface);
}
