/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

import java.util.List;

import org.kuali.rice.krad.datadictionary.RelationshipDefinition;
import org.kuali.rice.krad.document.Document;

/**
 * Adapter that supports "legacy" KNS/KRAD persistence, metadata, and object utility frameworks via runtime
 * argument inspection
 *
 * @deprecated This class is deprecated by default, applications should *never*
 * use this adapter directly
 *
 * @author Kuali Rice Team (rice.collab@kuali.org).
 */
@Deprecated
public interface LegacyDataAdapter extends LegacyDataAppAdapter {

    RelationshipDefinition getDictionaryRelationship(Class<?> c, String attributeName);

    /**
     * Finds the Document for the specified class with the given id.
     */
    <T extends Document> T findByDocumentHeaderId(Class<T> documentClass, String id);

    /**
     * Finds the Documents for the specified class with the given list of ids.
     */
    <T extends Document> List<T> findByDocumentHeaderIds(Class<T> documentClass, List<String> ids);

    String CLASS_NOT_PERSISTABLE_OJB_EXCEPTION_CLASS = "org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException";
    String OPTIMISTIC_LOCK_OJB_EXCEPTION_CLASS = "org.apache.ojb.broker.OptimisticLockException";
}
