/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

import org.kuali.rice.krad.uif.widget.DatePicker;

/**
 * Interface representing a text input control component. 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface TextControl extends Control {

    /**
     * @see org.kuali.rice.krad.uif.control.SizedControl#getSize()
     */
    int getSize();

    /**
     * @see org.kuali.rice.krad.uif.control.SizedControl#setSize(int)
     */
    void setSize(int size);

    /**
     * Maximum number of characters that can be inputted.
     *
     * <p>If not set on control, max length of field will be used</p>
     *
     * @return max number of characters
     */
    Integer getMaxLength();

    /**
     * @see TextControl#getMaxLength()
     */
    void setMaxLength(Integer maxLength);

    /**
     * Minimum number of characters that can be inputted.
     *
     * <p>If not set on control, min length of field will be used</p>
     *
     * @return max number of characters
     */
    Integer getMinLength();

    /**
     * @see TextControl#getMinLength()
     */
    void setMinLength(Integer minLength);

    /**
     * Renders a calendar that can be used to select a date value for the text control.
     *
     * @return data picker instance
     */
    DatePicker getDatePicker();

    /**
     * @see TextControl#getDatePicker()
     */
    void setDatePicker(DatePicker datePicker);

    /**
     * If set to true, this control will have a button which can be clicked to expand the text area through
     * a popup window so the user has more space to type and see the data they are entering in this text field.
     *
     * @return boolean if control has text expand enabled, false if not
     */
    boolean isTextExpand();

    /**
     * @see TextControl#isTextExpand()
     */
    void setTextExpand(boolean b);

    /**
     * Gets the watermark text for this TextControl.
     *
     * <p>A watermark typically appears as light gray text within the text input element whenever the
     * element is empty and does not have focus. This provides a hint to the user as to what the input
     * is used for, or the type of input that is required.</p>
     *
     * @return the watermarkText
     */
    String getWatermarkText();

    /**
     * @see TextControl#getWatermarkText()
     */
    void setWatermarkText(String watermark);

}
