/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.element;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

/**
 * The NextPager widget is used to display previous and next links.  This widget needs to
 * know the numberOfPages total, and the currentPage the user is on currently, so this widget must be fed this
 * information from the code.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @see org.kuali.rice.krad.uif.layout.StackedLayoutManager
 */
@BeanTag(name = "nextPager", parent = "Uif-NextPager")
public class NextPager extends Pager {
    private static final long serialVersionUID = 181885730680331424L;

    private boolean centeredLinks;

    /**
     * When false, links will receive the next and previous classes which left and right align the links instead
     * of centering them.
     */
    @BeanTagAttribute
    public boolean isCenteredLinks() {
        return centeredLinks;
    }

    /**
     * @see NextPager#isCenteredLinks()
     */
    public void setCenteredLinks(boolean centeredLinks) {
        this.centeredLinks = centeredLinks;
    }
}
