/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.field;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.kuali.rice.krad.datadictionary.Copyable;

/**
 * Object that is returned for Ajax attribute queries and exposed
 * as JSON
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class AttributeQueryResult implements Serializable, Copyable {
    private static final long serialVersionUID = -6688384365943881516L;

    private String resultMessage;
    private String resultMessageStyleClasses;

    private Map<String, String> resultFieldData;
    private List<Object> resultData;

    public AttributeQueryResult() {
        resultFieldData = new HashMap<String, String>();
        resultData = new ArrayList<Object>();
    }

    /**
     * Message text that should display (if non empty) with the results.
     * Can be used to given messages such as data not found
     *
     * @return text to display with results
     */
    public String getResultMessage() {
        return resultMessage;
    }

    /**
     * Setter for the result message text
     *
     * @param resultMessage
     */
    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    /**
     * CSS Style classes that should be applied to the result message text
     *
     * @return CSS style classes
     */
    public String getResultMessageStyleClasses() {
        return resultMessageStyleClasses;
    }

    /**
     * Setter for the CSS style classes to use for the return message
     *
     * @param resultMessageStyleClasses
     */
    public void setResultMessageStyleClasses(String resultMessageStyleClasses) {
        this.resultMessageStyleClasses = resultMessageStyleClasses;
    }

    /**
     * Returns data for multiple fields as a Map where key is the field
     * name and map value is the field value
     *
     * @return result field data
     */
    public Map<String, String> getResultFieldData() {
        return resultFieldData;
    }

    /**
     * Setter for the map field data
     *
     * @param resultFieldData
     */
    public void setResultFieldData(Map<String, String> resultFieldData) {
        this.resultFieldData = resultFieldData;
    }

    /**
     * Result of an attribute query that will be sent back to the client
     *
     * @return result data
     */
    public List<Object> getResultData() {
        return resultData;
    }

    /**
     * Setter for the attribute query result data
     *
     * @param resultData
     */
    public void setResultData(List<Object> resultData) {
        this.resultData = resultData;
    }

    /**
     * @see Copyable#clone()
     */
    @Override
    public AttributeQueryResult clone() throws CloneNotSupportedException {
        return (AttributeQueryResult) super.clone();
    }

}
