/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.freemarker;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

import org.kuali.rice.krad.uif.component.Component;

import freemarker.core.Environment;
import freemarker.core.InlineTemplateAdaptor;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

/**
 * Inline FreeMarker template adaptor for supporting template.ftl 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class FreeMarkerTemplateAdaptor implements InlineTemplateAdaptor, Serializable {

    private static final long serialVersionUID = -4442716566711789593L;

    /**
     * Render a KRAD component template inline.
     * 
     * {@inheritDoc}
     */
    @Override
    public void accept(Environment env) throws TemplateException, IOException {
        Component component = FreeMarkerInlineRenderUtils.resolve(env, "component", Component.class);
        
        if (component == null) {
            return;
        }

        String body = FreeMarkerInlineRenderUtils.resolve(env, "body", String.class);
        boolean componentUpdate = Boolean.TRUE.equals(FreeMarkerInlineRenderUtils.resolve(env, "componentUpdate",
                Boolean.class));
        boolean includeSrc = Boolean.TRUE.equals(FreeMarkerInlineRenderUtils.resolve(env, "includeSrc", Boolean.class));
        @SuppressWarnings("unchecked")
        Map<String, TemplateModel> tmplParms = FreeMarkerInlineRenderUtils.resolve(env, "tmplParms", Map.class);
        FreeMarkerInlineRenderUtils.renderTemplate(env, component, body, componentUpdate, includeSrc, tmplParms);
    }

}
