/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle;

import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;

import java.util.List;

/**
 * Encapsulates the concept of creating {@link ViewLifecyclePhase} instances during a the view
 * lifecycle build process.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @see ViewLifecycleBuild
 */
public interface ViewLifecyclePhaseBuilder {

    /**
     * Creates a lifecycle phase instance for the given view.
     *
     * @param view view instance the phase should be built for
     * @param viewPhase View phase to build an instance for
     * @return pre-process phase instance
     * @see ViewLifecycle#getView()
     */
    ViewLifecyclePhase buildPhase(View view, String viewPhase, List<String> refreshPaths);

    /**
     * Creates a lifecycle phase instance for a specific component in the current lifecycle.
     *
     * @param viewPhase view phase to build an instance for
     * @param element lifecycle element to build an instance for
     * @param parent parent component
     * @param parentPath path relative to the parent component referring to the lifecycle element
     * @return phase instance
     */
    ViewLifecyclePhase buildPhase(String viewPhase, LifecycleElement element, Component parent, String parentPath,
            List<String> refreshPaths);

}
