/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.initialize;

import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.view.ViewModel;

/**
 * Invoke custom initialization on the container from the view helper.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class InitializeContainerFromHelperTask extends ViewLifecycleTaskBase<Container> {

    public InitializeContainerFromHelperTask() {
        super(Container.class);
    }

    /**
     * Invoke custom initialization based on the view helper.
     * 
     * {@inheritDoc}
     */
    @Override
    protected void performLifecycleTask() {
        // invoke hook point for adding components through code
        ViewLifecycle.getHelper().addCustomContainerComponents((ViewModel)ViewLifecycle.getModel(),
                (Container) getElementState().getElement());
    }

}
