/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.initialize;

import org.kuali.rice.krad.uif.lifecycle.LifecycleElementState;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;

/**
 * Assigns a lifecycle element's path property {@link LifecycleElement#setViewPath(String)} and
 * {@link LifecycleElement#setPath(String)}, based on the paths to the element from
 * {@link LifecycleElementState}.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class PopulatePathTask extends ViewLifecycleTaskBase<LifecycleElement> {

    /**
     * Creates an instance based on element state.
     */
    public PopulatePathTask() {
        super(LifecycleElement.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void performLifecycleTask() {
        LifecycleElementState elementState = getElementState();
        LifecycleElement element = elementState.getElement();

        element.setViewPath(elementState.getViewPath());
    }

}
