/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.model;

import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ApplyModelComponentPhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;

/**
 * Perform default apply model behavior defined for the component.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ComponentDefaultApplyModelTask extends ViewLifecycleTaskBase<Component> {

    /**
     * Create a task to assign component IDs during the apply model phase.
     */
    public ComponentDefaultApplyModelTask() {
        super(Component.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplyModelComponentPhase getElementState() {
        return (ApplyModelComponentPhase) super.getElementState();
    }

    /**
     * {@inheritDoc}
     */
    @SuppressWarnings("deprecation")
    @Override
    protected void performLifecycleTask() {
        ApplyModelComponentPhase phase = getElementState();
        phase.getElement().performApplyModel(ViewLifecycle.getModel(), phase.getParent());
    }

}
