/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.model;


import org.kuali.rice.krad.uif.lifecycle.ApplyModelComponentPhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;

/**
 * Push attributes to the component context.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class PopulateComponentContextTask extends ViewLifecycleTaskBase<LifecycleElement> {

    public PopulateComponentContextTask() {
        super(LifecycleElement.class);
    }

    @Override
    public ApplyModelComponentPhase getElementState() {
        return (ApplyModelComponentPhase) super.getElementState();
    }

    @Override
    protected void performLifecycleTask() {
        LifecycleElement element = getElementState().getElement();
        LifecycleElement parent = getElementState().getParent();

        ViewLifecycle.getHelper().setElementContext(element, parent);
    }

}
