/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.mock;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.util.SessionTransient;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * Form class for {@link org.kuali.rice.krad.uif.mock.MockView} instances that holds data in generic maps.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DynaForm extends UifFormBase {
    private static final long serialVersionUID = -2112462466031059707L;

    private Map<String, Object> data;
    private Map<String, Boolean> booleanData;

    @SessionTransient
    private boolean initialGetRequest;

    public DynaForm() {
        super();
    }

    @Override
    public void postBind(HttpServletRequest request) {
        // form key is assigned in super so need to do this check before it executes
        if (StringUtils.isBlank(getFormKey()) && request.getMethod().equals(RequestMethod.GET.name())) {
            initialGetRequest = true;
        }

        super.postBind(request);
    }

    /**
     * Map containing non-boolean data for the view.
     *
     * @return map where key is property name and value is the property value
     */
    public Map<String, Object> getData() {
        return data;
    }

    /**
     * @see DynaForm#getData()
     */
    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    /**
     * Map containing boolean data for the view.
     *
     * @return map where key is property name and value is the property value
     */
    public Map<String, Boolean> getBooleanData() {
        return booleanData;
    }

    /**
     * @see DynaForm#getBooleanData()
     */
    public void setBooleanData(Map<String, Boolean> booleanData) {
        this.booleanData = booleanData;
    }

    /**
     * Indicates whether the request is the initial get request for the view.
     *
     * @return boolean true if this is the initial request, false if not
     */
    public boolean isInitialGetRequest() {
        return initialGetRequest;
    }
}
