/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Map implementation takes a <code>Set</code> of Strings and converts to Map
 * where the string is the map key and value is the Boolean true, convenience
 * collection for expression language.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class BooleanMap extends HashMap<String, Boolean> {
    private static final long serialVersionUID = 4042557657401395547L;

    /**
     * Copy constructor.
     *
     * @param m map to copy
     */
    public BooleanMap(Map<? extends String, ? extends Boolean> m) {
        super(m);
    }

    /**
     * Sets an initial value of {@link Boolean#TRUE} for a given provided set of keys.
     *
     * @param keys set of keys to map to {@link Boolean#TRUE}
     */
    public BooleanMap(Set<String> keys) {
        super();

        for (String key : keys) {
            this.put(key, Boolean.TRUE);
        }
    }

    /**
     * Overrides the get method to return Boolean false if the key does not
     * exist in the Map.
     *
     * {@inheritDoc}
     */
    @Override
    public Boolean get(Object key) {
        if (super.containsKey(key)) {
            return super.get(key);
        }

        return Boolean.FALSE;
    }

}
