/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.view;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Provides cache objects for KIM authorization during a single request
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class RequestAuthorizationCache implements Serializable {
    private static final long serialVersionUID = 4773874972787299349L;

    private Map<String, Boolean> permissionResultCache;

    public RequestAuthorizationCache() {
        permissionResultCache = new HashMap<String, Boolean>();
    }

    /**
     * Map that can be used to cache results of permission checks for a request
     *
     * @return
     */
    public Map<String, Boolean> getPermissionResultCache() {
        return permissionResultCache;
    }

    public boolean hasPermissionResult(String resultKey) {
        return permissionResultCache.containsKey(resultKey);
    }

    public Boolean getPermissionResult(String resultKey) {
        Boolean result = null;

        if (hasPermissionResult(resultKey)) {
            result = Boolean.valueOf(permissionResultCache.get(resultKey));
        }

        return result;
    }

    public void addPermissionResult(String resultKey, boolean result) {
        permissionResultCache.put(resultKey, Boolean.valueOf(result));
    }
}
