/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.widget;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

import java.util.HashMap;
import java.util.Map;

/**
 * BlockUI element is used within the view element for managing element/page blocking attributes
 *
 * <p>
 * Some basic options of the plugin are exposed through this class. Messages can be managed via
 * Action elements. See the jquery BlockUI plugin for more details.
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "blockUI", parent = "Uif-BlockUI")
public class BlockUI extends WidgetBase {

    private String blockingImageSource;

    public BlockUI() {
        super();
    }

    /**
     * Override to add property values to the template options
     *
     * {@inheritDoc}
     */
    @Override
    public Map<String, String> getTemplateOptions() {
        Map<String, String> templateOptions = super.getTemplateOptions();

        if (templateOptions == null) {
            super.setTemplateOptions(templateOptions = new HashMap<String, String>());
        }

        if (StringUtils.isNotBlank(blockingImageSource) && !templateOptions.containsKey("blockingImage")) {
            templateOptions.put("blockingImage", blockingImageSource);
        }

        return templateOptions;
    }

    /**
     * Path to an image that will be rendered in the blocking overlay
     *
     * <p>
     * If specified, the image will be picked up and rendered before the blocking message in
     * the overlay. If not given just the message will be displayed
     * </p>
     *
     * @return url to the blocking image
     */
    @BeanTagAttribute
    public String getBlockingImageSource() {
        return blockingImageSource;
    }

    /**
     * Setter for the url (source) of the blocking image to use (if any)
     *
     * @param blockingImageSource
     */
    public void setBlockingImageSource(String blockingImageSource) {
        this.blockingImageSource = blockingImageSource;
    }
}
