/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util.documentserializer;

import org.kuali.rice.krad.document.Document;

/**
 * This implementation of {@link PropertySerializabilityEvaluator} specifies that all properties of a document are serializable.
 *
 */
public class AlwaysTruePropertySerializibilityEvaluator extends PropertySerializabilityEvaluatorBase {

    /**
     * Does nothing, since we know everything's serializable
     */
	@Override
    public void initializeEvaluatorForDocument(Document document) {
    }

    /**
     * Trivially returns true
     *
     * {@inheritDoc}
     */
	@Override
    public boolean isPropertySerializable(SerializationState state, Object containingObject, String childPropertyName, Object childPropertyValue) {
        return true;
    }
}
