/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.bind;

import org.kuali.rice.core.api.util.RiceKeyConstants;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.PropertyAccessException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultBindingErrorProcessor;

/**
 * UIF handler for binding processing errors
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class UifBindingErrorProcessor extends DefaultBindingErrorProcessor {

    /**
     * Adds an entry to the {@link org.kuali.rice.krad.util.GlobalVariables#getMessageMap()} for the given
     * binding processing error
     *
     * @param ex exception that was thrown
     * @param bindingResult binding result containing the results of the binding process
     */
    @Override
    public void processPropertyAccessException(PropertyAccessException ex, BindingResult bindingResult) {
        // Create field error with the exceptions's code, e.g. "typeMismatch".
        super.processPropertyAccessException(ex, bindingResult);

        Object rejectedValue = ex.getValue();
        if (!(rejectedValue == null || rejectedValue.equals(""))) {
            if (ex.getCause() instanceof FormatException) {
                GlobalVariables.getMessageMap().putError(ex.getPropertyName(),
                        ((FormatException) ex.getCause()).getErrorKey(),
                        new String[] {rejectedValue.toString()});
            } else {
                GlobalVariables.getMessageMap().putError(ex.getPropertyName(), RiceKeyConstants.ERROR_CUSTOM,
                        new String[] {"Invalid format"});
            }
        }
    }
}
