/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.bind;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;

/**
 * PropertyEditor converts between date display strings and
 * <code>java.sql.Timestamp</code> objects using the
 * <code>org.kuali.rice.core.api.datetime.DateTimeService</code>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class UifTimestampEditor extends UifDateEditor implements Serializable {
    private static final long serialVersionUID = -2776193044590819394L;

    /**
     * This overridden method uses the
     * <code>org.kuali.rice.core.api.datetime.DateTimeService</code> to convert
     * the time stamp object to the display string.
     *
     * @see UifDateEditor#getAsText()
     */
    @Override
    public String getAsText() {
        if (this.getValue() == null) {
            return null;
        }
        if ("".equals(this.getValue())) {
            return null;
        }

        return getDateTimeService().toDateTimeString((Timestamp) this.getValue());
    }

    /**
     * This overridden method converts the display string to a
     * <code>java.sql.Timestamp</code> object using the
     * <code>org.kuali.rice.core.api.datetime.DateTimeService</code>.
     *
     * @see UifDateEditor#setAsText(java.lang.String)
     */
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(new Timestamp(((Date) super.convertToObject(text)).getTime()));
    }

}
