/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.controller;

import org.kuali.rice.core.api.exception.RiceRuntimeException;

/**
 * Runtime exception thrown when a controller method is requested that is not accessible.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class MethodAccessException extends RiceRuntimeException {
    private static final long serialVersionUID = -4173237177827444387L;

    private final Class<?> controllerClass;
    private final String methodToCall;

    public MethodAccessException(Class<?> controllerClass, String methodToCall) {
        super("Access is protected for controller: " + controllerClass.getName() + " and method: " + methodToCall);

        this.controllerClass = controllerClass;
        this.methodToCall = methodToCall;
    }

    /**
     * Class of the controller the method was requested for.
     *
     * @return controller class
     */
    public Class<?> getControllerClass() {
        return controllerClass;
    }

    /**
     * Name of the controller method that was requested.
     *
     * @return controller method name
     */
    public String getMethodToCall() {
        return methodToCall;
    }
}
