/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.login;


import org.kuali.rice.krad.uif.component.RequestParameter;
import org.kuali.rice.krad.web.bind.RequestAccessible;
import org.kuali.rice.krad.web.form.UifFormBase;

/**
 * Basic form for Dummy Login.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DummyLoginForm extends UifFormBase {
    private static final long serialVersionUID =  -7525378097732816418L;

    protected String login_user;
    protected String login_pw;

    protected String backdoorId;

    @RequestAccessible
    @RequestParameter
    protected String login_message;

    public DummyLoginForm() {
        super();

        login_message = "";
    }

    public String getLogin_user() {
        return login_user;
    }

    public void setLogin_user(String login_user) {
        this.login_user = login_user;
    }

    public String getLogin_pw() {
        return login_pw;
    }

    public void setLogin_pw(String login_pw) {
        this.login_pw = login_pw;
    }

    public String getLogin_message() {
        return login_message;
    }

    public void setLogin_message(String login_message) {
        this.login_message = login_message;
    }

    public String getBackdoorId() { return backdoorId; }

    public void setBackdoorId(String id) {
        backdoorId = id;
    }
}
