/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.service;

import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.servlet.ModelAndView;

/**
 * Controller service that handles the refresh method.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface RefreshControllerService {

    /**
     * Invoked when returning from another view.
     *
     * <p>Several places in the framework do a return from a view to another view. Examples are return from
     * a lookup, breadcrumb navigation, and navigation methods provided by the controller. This is the default
     * method invoked when returning to perform any additional functionality.</p>
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView refresh(UifFormBase form);
}
